<?php
/**
 * 
 * @package aowp.aspect.joinpoint
 */
/**
 * 関数呼び出しを表すジョインポイントです。
 * 
 * @author keiji
 * @package aowp.aspect.joinpoint
 *
 */
class AOWP_FunctionCallJoinPoint extends AOWP_JoinPointWithArguments {
	
	/**
	 * 
	 * @var string
	 */
	private $_functionName;
	private $_staticArgumentCount;

	public function __construct(AOWP_PHPFunctionCallElement $element = null, $fileName = null) {
		parent::__construct($element, $fileName);
		$this->setFunctionName($element->getFunctionName());
		$this->setStaticArgumentCount($element->getArgumentCount());
	}
	
	public function setStaticArgumentCount($staticArgumentCount) {
		$this->_staticArgumentCount = $staticArgumentCount;
	}
	public function getStaticArgumentCount() {
		return $this->_staticArgumentCount;
	}
	
	public function setFunctionName($functionName) {
		$this->_functionName = $functionName;
	}
	/**
	 * 関数名を取得します。
	 * 
	 * @return string
	 */
	public function getFunctionName() {
		return $this->_functionName;
	}
	
	public function proceed(array $argumentArray = array()) {
		if ($this->_proceedFunctionName !== null) {
			return call_user_func_array($this->_proceedFunctionName, $argumentArray);
		}
	}
	
}
?>