<?php
/**
 * Enter description here...
 * @package aowp.aspect.weaver
 */
class AOWP_PHPFileManager {

	private static $_PHP_FILE_NAME_ARRAY = null;

	/**
	 * 指定したフォルダ配下の全てのPHPファイルのフルパスを返します。
	 *
	 * @param unknown_type $directoryPath 織り込み対象のプロジェクトのルートフォルダ。無しの時は、AOWP_PHPFileManager::BASE_PATHが使われる。
	 * @return unknown
	 */
	private static function _getAllPHPFile($directoryPath, $includePattern = null){
		$phpFileNameArray = array();

		if ($directoryPath != AOWP_Configuration::RUNTIME_DATA_FOLDER) {
			$directory = dir($directoryPath);
			while (($fileName = $directory->read()) !== false) {
				if ($fileName == '.' || $fileName == '..') {
						
				}
				else if ($fileName == AOWP_ConfigurationManager::getCacheFolder()) {
						
				}
				else if (AOWP_Configuration::EXCLUDE_PHP_FILE_PATERN != '' &&
				preg_match(AOWP_Configuration::EXCLUDE_PHP_FILE_PATERN, $fileName)) {

				}
				else if (is_dir($directoryPath . DIRECTORY_SEPARATOR . $fileName)) {
					$phpFileNameArray = array_merge($phpFileNameArray, AOWP_PHPFileManager::_getAllPHPFile($directoryPath . DIRECTORY_SEPARATOR . $fileName, $includePattern));
				}
				else if (preg_match(AOWP_Configuration::INCLUDE_PHP_FILE_PATERN, $fileName) &&
				($includePattern === null || preg_match($includePattern, $fileName))) {
					$phpFileNameArray[] = $directory->path . DIRECTORY_SEPARATOR . $fileName;
				}
			}
		}
		return $phpFileNameArray;
	}

	public static function getAllAspectPHPFile() {
		return AOWP_PHPFileManager::_getAllPHPFile(AOWP_Configuration::ASPECT_DIR_PATH, '/Aspect\.class\.php$/');
	}

	public static function getAllProjectPHPFile(){
		return AOWP_PHPFileManager::_getAllPHPFile(AOWP_Configuration::PROJECT_HOME_PATH);
	}

	private static function _getBackupPath() {
		return AOWP_Configuration::PROJECT_HOME_PATH . '.org';
	}

	public static function _isWindows() {
		return strtoupper(substr(PHP_OS, 0, 3)) === 'WIN';
	}

	public static function removeFolder($path) {
		if (AOWP_PHPFileManager::_isWindows()) {
			system("rmdir \"$path\" /s /q");
		}
		else {
			system("rm -rf $path");
		}
	}

	public static function mkdir($path) {
		if (AOWP_PHPFileManager::_isWindows()) {
			system("mkdir \"$path\"");
		}
		else {
			mkdir($path, 0777, true);
			system("chmod -R 777 $path");
		}
	}
	
	public static function saveFile($savePath, $content) {
		return file_put_contents($savePath, $content) && chmod($savePath, 0777);
	}

	public static function copy($src, $dist) {
		if (AOWP_PHPFileManager::_isWindows()) {
			if (!file_exists("\"$dist\"")){
				mkdir($dist);
			}
			system("xcopy \"$src\" \"$dist\" /E /Y");
		}
		else {
			system("cp -Rf $src $dist");
			system("chmod -R 777 $dist");
		}
	}

	public static function move($src, $dist) {
		if (AOWP_PHPFileManager::_isWindows()) {
			system("move \"$src\" \"$dist\"");
		}
		else {
			system("mv $src $dist");
			system("chmod -R 777 $dist");
		}
	}

	public static function backupOriginalPHPFile() {
		if (!file_exists(AOWP_PHPFileManager::_getBackupPath())) {
			AOWP_PHPFileManager::copy(AOWP_Configuration::PROJECT_HOME_PATH, AOWP_PHPFileManager::_getBackupPath());
		}
	}

	public static function undoWeaving() {
		if (file_exists(AOWP_PHPFileManager::_getBackupPath())) {
			AOWP_PHPFileManager::removeFolder(AOWP_Configuration::PROJECT_HOME_PATH);
			AOWP_PHPFileManager::move(AOWP_PHPFileManager::_getBackupPath(), AOWP_Configuration::PROJECT_HOME_PATH);
		}
	}
}
?>