<?php
/**
 * 
 */
/**
 * 
 * @author keiji
 *
 */
class ALP_ClassDefLocMap {
	const MAPPING_INFORMATION_DELIMITER = '#';
	const LINE_FEED = "\n";
	
	private $_classDefLocMap = array();
	private static $_cacheClassDefLocMap = null;
	
	private static function _getMappingLocation() {
		return dirname(__FILE__) . '/mapping.txt';
	}
	
	public function __construct($newFlag = false) {
		if (!$newFlag) {
			$this->loadMapping();
		}
	}
	
	public function getDefLocMapArray() {
		return $this->_classDefLocMap;
	}
	
	public static function getClassDefinitionLocation($className, $refleshMapInstance = false) {
		if ($refleshMapInstance || ALP_ClassDefLocMap::$_cacheClassDefLocMap === null) {
			ALP_ClassDefLocMap::$_cacheClassDefLocMap = new ALP_ClassDefLocMap();
		}
		return ALP_ClassDefLocMap::$_cacheClassDefLocMap->getClassDefLoc($className);
	}
	
	public function addClassDefLoc($className, $scriptLocation) {
		$this->_classDefLocMap[$className] = $scriptLocation;
	}
	public function getClassDefLoc($className) {
		return isset($this->_classDefLocMap[$className]) ? $this->_classDefLocMap[$className] : null;
	}
	
	public function merge(ALP_ClassDefLocMap $targetDefLocMap) {
		$this->_classDefLocMap = array_merge($this->_classDefLocMap, $targetDefLocMap->getDefLocMapArray());
	}
	
	public function loadMapping() {
		if (file_exists(ALP_ClassDefLocMap::_getMappingLocation())) {
			$mappingText = file_get_contents(ALP_ClassDefLocMap::_getMappingLocation());
			$mappingLineArray = explode(ALP_ClassDefLocMap::LINE_FEED, $mappingText);
			foreach ($mappingLineArray as $mappingLine) {
				$mappingInformation = explode(ALP_ClassDefLocMap::MAPPING_INFORMATION_DELIMITER, $mappingLine);
				if (count($mappingInformation) == 2) {
					$this->addClassDefLoc($mappingInformation[0], $mappingInformation[1]);
				}
			}
		}
	}
	public function saveMapping() {
		$mappingText = '';
		foreach ($this->_classDefLocMap as $className => $classLocation) {
			$mappingText .= ($className . ALP_ClassDefLocMap::MAPPING_INFORMATION_DELIMITER . $classLocation . ALP_ClassDefLocMap::LINE_FEED);
		}
		file_put_contents(ALP_ClassDefLocMap::_getMappingLocation(), $mappingText);
	}
	
}
?>