<?php
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR .
	'..' . DIRECTORY_SEPARATOR .
	'libs' . DIRECTORY_SEPARATOR .
	'autoloadplus' . DIRECTORY_SEPARATOR .
	'bin' . DIRECTORY_SEPARATOR .
	'include.php';

//ini_set("memory_limit", "64M");
ini_set("memory_limit", "1024M");
AOWP_ConfigurationManager::$WEAVING_TIME_FLAG = true;
$commandOption = new AOWP_CommandOption($argv, $argc);
if ($commandOption->isPerformanceTest()) {
	echo "[Start of performance test.]\n";
	AOWP_Logger::$LOGGING_FLAG = AOWP_Logger::PERFORMANCE_TEST_MODE;
	AOWP_Logger::startPerformanceTest();
}
else {
	AOWP_Logger::$LOGGING_FLAG = AOWP_Logger::DEBUG_MODE;
}
if ($commandOption->isDoSetupEnv()) {
	if ($commandOption->isPerformanceTest()) {
		echo "[Start of setup.]\n";
	}
	if (include $commandOption->getConfigFilePath()) {
		if (!isset($AOWP_CONF_INCLUDE_FILE_PATTERN)) {
			$AOWP_CONF_INCLUDE_FILE_PATTERN = '/.php$/';
		}
		if (!isset($AOWP_CONF_EXCLUDE_FILE_PATTERN)) {
			$AOWP_CONF_EXCLUDE_FILE_PATTERN = '/.bk$/';
		}
		if (!isset($AOWP_CONF_DATA_FOLDER_NAME)) {
			$AOWP_CONF_DATA_FOLDER_NAME = 'aowp';
		}
		if (isset($AOWP_CONF_AOWP_HOME) && isset($AOWP_CONF_PROJECT_PATH) &&
			isset($AOWP_CONF_ASPECT_PATH) && isset($AOWP_CONF_DATA_FOLDER_NAME)) {

			AOWP_ConfigurationManager::setupConfiguration(
				$AOWP_CONF_AOWP_HOME,
				$AOWP_CONF_PROJECT_PATH,
				$AOWP_CONF_ASPECT_PATH,
				$AOWP_CONF_DATA_FOLDER_NAME,
				$AOWP_CONF_INCLUDE_FILE_PATTERN,
				$AOWP_CONF_EXCLUDE_FILE_PATTERN);
			
			// Create data folder for weaving.
			if (!file_exists(AOWP_ConfigurationManager::getCacheFolder())) {
				AOWP_Logger::setStartTime();
				AOWP_Logger::logging(AOWP_ConfigurationManager::getCacheFolder());
				mkdir(AOWP_ConfigurationManager::getCacheFolder());
				AOWP_Logger::logging('[Mkdir] Make cache data folder <' . AOWP_ConfigurationManager::getCacheFolder() . '>');
			}
		}
		else {
			exit();
		}
	}
	else {
		exit();
	}
	if ($commandOption->isPerformanceTest()) {
		echo "[End of setup.]\n";
		AOWP_Logger::performanceTestResult(true);
	}
}
if ($commandOption->isDoParse()) {
	if ($commandOption->isPerformanceTest()) {
		echo "[Start of parse.]\n";
	}
	AOWP_Logger::logging('[AOWP compiler] Start parsing.');
	AOWP_Logger::setStartTime(1);
	$astManager = new AOWP_ASTManager();
	$astManager->createAllASTCache();
	AOWP_Logger::logging('[AOWP compiler] End parsing.', 1);
	if ($commandOption->isPerformanceTest()) {
		echo "[End of parse.]\n";
		AOWP_Logger::performanceTestResult(true);
	}
}
if ($commandOption->isDoWeaving()) {
	if ($commandOption->isPerformanceTest()) {
		echo "[Start of weaving.]\n";
	}
	AOWP_Logger::logging('[AOWP compiler] Start weaving.');
	AOWP_Logger::setStartTime(3);
	AOWP_ConfigurationManager::setupAspectForRuntime();
	$weaver = new AOWP_Weaver();
	$weaver->weaveAllAspect();
	AOWP_Logger::logging('[AOWP compiler] End weaving.', 3);
	if ($commandOption->isPerformanceTest()) {
		echo "[End of weaving.]\n";
		AOWP_Logger::performanceTestResult(true);
	}
}
if ($commandOption->isDoGenerateWovenSource()) {
	if ($commandOption->isPerformanceTest()) {
		echo "[Start of generating woven source.]\n";
	}
	AOWP_Logger::logging('[AOWP compiler] Start generating source.');
	AOWP_Logger::setStartTime(3);
	AOWP_ASTManager::generateWovenSource();
	AOWP_Logger::logging('[AOWP compiler] End generating source.', 3);
	AOWP_ConfigurationManager::setupRuntimeEnvironment();
	AOWP_Logger::logging('[AOWP compiler] Setup runtime environment.');
	if ($commandOption->isPerformanceTest()) {
		echo "[End of generating woven source.]\n";
		AOWP_Logger::performanceTestResult(true);
	}
}
if ($commandOption->isDoSetupRuntime()) {
	if ($commandOption->isPerformanceTest()) {
		echo "[Start of setup runtime.]\n";
	}
	AOWP_ConfigurationManager::setupRuntimeEnvironment();
	AOWP_Logger::logging('[AOWP compiler] Setup runtime environment.');
	if ($commandOption->isPerformanceTest()) {
		echo "[End of setup runtime.]\n";
		AOWP_Logger::performanceTestResult(true);
	}
}
if ($commandOption->isDoUndo()) {
	AOWP_PHPFileManager::undoWeaving();
}
if ($commandOption->isCount()) {
	$totalLOC = 0;
	$allPHPFilePathArray = AOWP_PHPFileManager::getAllProjectPHPFile();
	foreach ($allPHPFilePathArray as $phpFilePath) {
		echo $phpFilePath . "\n";
		$sourceCode = file_get_contents($phpFilePath);
		$lineArray = explode("\n", $sourceCode);
		$totalLOC += count($lineArray);
	}
	echo 'Project file number: ' . count($allPHPFilePathArray) . ', Project LOC: ' . $totalLOC . "\n";
}
if ($commandOption->isPerformanceTest()) {
	echo "[End of performance test.]\n";
	AOWP_Logger::performanceTestResult();
}

class AOWP_CommandOption {
	private $_configFilePath = null;
	private $_isDoSetupEnv = false;
	private $_isDoParse = false;
	private $_isDoWeaving = false;
	private $_isDoGenerateWovenSource = false;
	private $_isDoUndo = false;
	private $_isSetupRuntimeEnvironment = false;
	private $_isPerformanceTestMode = false;
	private $_isCount = false;
	
	public function __construct($argv, $argc) {
		if (!isset($argv) || !isset($argc)) {
			echo "Bad arguments\n.";
			exit();
		}
		for ($i = 0; $i < $argc; $i++) {
			switch ($argv[$i]) {
				case 'config':
					if ($i + 1 <= $argc) {
						$i++;
						$this->_configFilePath = $argv[$i]; 
					}
					else {
						echo 'Need a path of a configuration file.';
						exit();
					}
					break;
				case 'env':
					$this->_isDoSetupEnv = true;
					break;
				case 'parse':
					$this->_isDoParse = true;
					break;
				case 'weaving':
					$this->_isDoWeaving = true;
					break;
				case 'source':
					$this->_isDoGenerateWovenSource = true;
					break;
				case 'setup_runtime':
					$this->_isSetupRuntimeEnvironment = true;
					break;
				case 'performance_test':
					$this->_isPerformanceTestMode = true;
					break;
				case 'undo':
					$this->_isDoUndo = true;
					break;
				case 'count':
					$this->_isCount = true;
					break;
				case 'all':
					$this->_isDoSetupEnv = true;
					$this->_isDoParse = true;
					$this->_isDoWeaving = true;
					$this->_isDoGenerateWovenSource = true;
					break;
			}
			$this->_configFilePath = $this->_configFilePath !== null ? $this->_configFilePath : 'aowp_conf.php';
		}
	}
	
	public function getConfigFilePath() {
		return $this->_configFilePath;
	}
	public function isDoSetupRuntime() {
		return $this->_isSetupRuntimeEnvironment;
	}
	public function isDoSetupEnv() {
		return $this->_isDoSetupEnv;
	}
	public function isDoParse() {
		return $this->_isDoParse;
	}
	public function isDoWeaving() {
		return $this->_isDoWeaving;
	}
	public function isDoGenerateWovenSource() {
		return $this->_isDoGenerateWovenSource;
	}
	public function isDoUndo() {
		return $this->_isDoUndo;
	}
	public function isPerformanceTest() {
		return $this->_isPerformanceTestMode;
	}
	public function isCount() {
		return $this->_isCount;
	}
}
?>