<?php
/**
 * 短い説明文
 * 
 * 長い説明文
 * 
 * @package aowp.aspect.joinpoint
 */
/**
 * JoinPointCreator.class
 *
 * @package aowp.aspect.joinpoint
 */
class AOWP_JoinPointCreator {

	/**
	 * ASTからジョインポイントを作ります。
	 *
	 * @param AOWP_PHPElement $ast PHPの構文要素。AOWP_PHPElementのサブクラス。
	 * @return AOWP_JoinPoint or null
	 */
	public static function createJoinPoint(&$ast, $fileName) {
		if ($ast instanceof AOWP_PHPRootElement) {
			return new AOWP_ScriptExecutionJoinPoint($ast, $fileName);
		}
		else if ($ast instanceof AOWP_PHPFunctionElement) {
			return new AOWP_FunctionExecutionJoinPoint($ast, $fileName);
		}
		else if ($ast instanceof AOWP_PHPMethodElement) {
			return new AOWP_MethodExecutionJoinPoint($ast, $fileName);
		}
		else if ($ast instanceof AOWP_PHPObjectPropertyElement) {
			if ($ast->isMethodCall()) {
				return new AOWP_MethodCallJoinPoint($ast, $fileName);
			}
		}
		else if ($ast instanceof AOWP_PHPFunctionCallElement) {
			return new AOWP_FunctionCallJoinPoint($ast, $fileName);
		}
		else if ($ast instanceof AOWP_PHPExitExprElement) {
			return new AOWP_ExitJoinPoint($ast, $fileName);
		}
	}
}

?>