<?php
/**
 * 
 */
/**
 * 
 * @author keiji
 *
 */
class ALP_Configuration {
	const PROJECT_LOCATION_TEXT_NAME = 'project_location.txt';
	
	private static function getConfigurationTextPath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . ALP_Configuration::PROJECT_LOCATION_TEXT_NAME;
	}
	
	public static function getProjectLocation() {
		$projectLocation = file_get_contents(ALP_Configuration::getConfigurationTextPath());
		return strpos($projectLocation, DIRECTORY_SEPARATOR) === 0 ?
			$projectLocation :
			dirname(__FILE__) . DIRECTORY_SEPARATOR . $projectLocation;
	}
	public static function setProjectLocation($projectLocation, $libraryRootFolder = null) {
		$saveLocation = $libraryRootFolder !== null ?
			$libraryRootFolder . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . ALP_Configuration::PROJECT_LOCATION_TEXT_NAME :
			dirname(__FILE__) . DIRECTORY_SEPARATOR . ALP_Configuration::PROJECT_LOCATION_TEXT_NAME;
		return file_put_contents($saveLocation, ALP_ClassDefLocMap::getRelativePath($projectLocation, dirname(__FILE__)));
	}
	
	/**
	 * 引き数で渡されたスクリプトファイルが、クラスを定義したファイルかどうかを評価します。
	 * この関数では、そのスクリプトファイルが定義したクラス名を入れた配列を、返します。
	 * クラスを定義していない場合、空の配列を返して下さい。
	 * この関数は、各プロジェクトごとの、命名規則や、フォルダ階層に応じて実装して下さい。
	 * 
	 * @param $fileName 評価されるスクリプトファイル名
	 * @param $folderPath 評価されるスクリプトファイルが置かれたフォルダのパス
	 * @return array 定義されたクラス名を入れた配列
	 */
	public static function getClassNames($fileName, $folderPath) {
//		return array();
		if ($fileName === 'Parser.php') {
			return array('PHP_Parser');
		}
		else if ($fileName === 'Core.php') {
			return array('PHP_Parser_Core', 'PHP_Parser_CoreyyStackEntry', 'PHP_Parser_CoreyyToken');
		}
		else if ($fileName === 'Tokenizer.php') {
			return array('PHP_Parser_Tokenizer');
		}
		$fileNameArray = explode('.class.', $fileName);
		if (count($fileNameArray) == 2) {
			return array('AOWP_' . $fileNameArray[0]);
		}
		else {
			return array();
		}
	}
	
}
?>