<?php
/**
 * Enter description here...
 * @package aowp.aspect.weaver
 */
class AOWP_PHPFileManager {
	const REAL_PATH_PATTERN = '/(^[a-zA-Z]:)|(^\/)/';

	private static $_PHP_FILE_NAME_ARRAY = null;

	/**
	 * 指定したフォルダ配下の全てのPHPファイルのフルパスを返します。
	 *
	 * @param unknown_type $directoryPath 織り込み対象のプロジェクトのルートフォルダ。無しの時は、AOWP_PHPFileManager::BASE_PATHが使われる。
	 * @return unknown
	 */
	public static function getAllPHPFile($directoryPath, $includePattern = null){
		$phpFileNameArray = array();

		if ($directoryPath != AOWP_ConfigurationManager::getRuntimeDataFolder()) {
			$directory = dir($directoryPath);
			while (($fileName = $directory->read()) !== false) {
				if ($fileName == '.' || $fileName == '..') {
						
				}
				else if ($fileName == AOWP_ConfigurationManager::getCacheFolder()) {
						
				}
				else if (AOWP_Configuration::EXCLUDE_PHP_FILE_PATERN != '' &&
				preg_match(AOWP_Configuration::EXCLUDE_PHP_FILE_PATERN, $fileName)) {

				}
				else if (is_dir($directoryPath . DIRECTORY_SEPARATOR . $fileName)) {
					$phpFileNameArray = array_merge($phpFileNameArray, AOWP_PHPFileManager::getAllPHPFile($directoryPath . DIRECTORY_SEPARATOR . $fileName, $includePattern));
				}
				else if (preg_match(AOWP_Configuration::INCLUDE_PHP_FILE_PATERN, $fileName) &&
				($includePattern === null || preg_match($includePattern, $fileName))) {
					$phpFileNameArray[] = $directory->path . DIRECTORY_SEPARATOR . $fileName;
				}
			}
		}
		return $phpFileNameArray;
	}

	public static function getAllProjectPHPFile(){
		return AOWP_PHPFileManager::getAllPHPFile(AOWP_ConfigurationManager::getProjectHomePath());
	}

	private static function _getBackupPath() {
		return AOWP_ConfigurationManager::getProjectHomePath() . '.org';
	}

	public static function _isWindows() {
		return strtoupper(substr(PHP_OS, 0, 3)) === 'WIN';
	}

	public static function removeFolder($path) {
//		$path = AOWP_PHPFileManager::_removeDotDotPath($path);
		if (AOWP_PHPFileManager::_isWindows()) {
			system("rmdir \"$path\" /s /q");
		}
		else {
			system("rm -rf $path");
		}
	}

	public static function mkdir($path) {
//		$path = AOWP_PHPFileManager::_removeDotDotPath($path);
//		echo $path;
		if (AOWP_PHPFileManager::_isWindows()) {
			system("mkdir \"$path\"");
		}
		else {
			mkdir($path, 0777, true);
//			system("mkdir $path");
			system("chmod -R 777 $path");
		}
	}
	
	public static function saveFile($savePath, $content) {
//		$savePath = AOWP_PHPFileManager::_removeDotDotPath($savePath);
//		$content = AOWP_PHPFileManager::_removeDotDotPath($content);
		if (AOWP_PHPFileManager::_isWindows()) {
			return file_put_contents($savePath, $content);
		}
		else {
			return file_put_contents($savePath, $content) && system("chmod -R 777 $savePath") !== false;
//			return file_put_contents(AOWP_PHPFileManager::getRelativePath($savePath, dirname(__FILE__)), $content) &&
//				system("chmod -R 777 $savePath") !== false;
		}
	}

	public static function copy($src, $dist) {
		if (AOWP_PHPFileManager::_isWindows()) {
			if (is_dir($src) && dirname($src) == dirname($dist)) {
				
			}
			else {
				$dist = $dist . DIRECTORY_SEPARATOR . basename($src);
			}
			if (!file_exists('"' . $dist . '"')) {
				AOWP_PHPFileManager::mkdir($dist);
			}
			system('xcopy "' . $src . '" "' . $dist . '" /E /Y');
		}
		else {
			system("cp -Rf $src $dist");
			system("chmod -R 777 $dist");
		}
	}

	public static function move($src, $dist) {
		if (AOWP_PHPFileManager::_isWindows()) {
			AOWP_Logger::logging("move \"$src\" \"$dist\"");
			system("move \"$src\" \"$dist\"");
		}
		else {
			system("mv $src $dist");
			system("chmod -R 777 $dist");
		}
	}

	public static function backupOriginalPHPFile() {
		if (!file_exists(AOWP_PHPFileManager::_getBackupPath())) {
			AOWP_PHPFileManager::copy(AOWP_ConfigurationManager::getProjectHomePath(), AOWP_PHPFileManager::_getBackupPath());
		}
	}

	public static function undoWeaving() {
		if (file_exists(AOWP_PHPFileManager::_getBackupPath())) {
			AOWP_PHPFileManager::removeFolder(AOWP_ConfigurationManager::getProjectHomePath());
			AOWP_PHPFileManager::move(AOWP_PHPFileManager::_getBackupPath(), AOWP_ConfigurationManager::getProjectHomePath());
		}
	}
	
	private static function _getRelativePathAgainstRequestURL($targetPath) {
		return AOWP_PHPFileManager::getRelativePath($targetPath, $_SERVER['SCRIPT_FILENAME']);
	}
	
	public static function getRelativePath($targetPath, $baseFolderPath) {
		if (preg_match(AOWP_PHPFileManager::REAL_PATH_PATTERN, $targetPath)) {
			$relativePath = null;
//			$targetPath = AOWP_PHPFileManager::_removeDotDotPath($targetPath);
//			$baseFolderPath = AOWP_PHPFileManager::_removeDotDotPath($baseFolderPath);
			$targetPathArray = explode(DIRECTORY_SEPARATOR, $targetPath);
			$basePathArray = explode(DIRECTORY_SEPARATOR, $baseFolderPath);
			for ($i = 0; $i < count($basePathArray) && $i < count($targetPathArray); $i++) {
				if ($basePathArray[$i] != $targetPathArray[$i]) {
					break;
				}
			}
			for ($j = $i; $j < count($basePathArray); $j++) {
				if ($relativePath !== null) {
					$relativePath .= DIRECTORY_SEPARATOR;
				}
				$relativePath .= '..';
			}
			for ($k = $i; $k < count($targetPathArray); $k++) {
				if ($relativePath !== null) {
					$relativePath .= DIRECTORY_SEPARATOR;
				}
				$relativePath .= $targetPathArray[$k];
			}
			return $relativePath;
		}
		else {
			return $targetPath;
		}
	}
	
	private static function _removeDotDotPath($path) {
		$removedDotPathArray = array();
		$removedDotPathArrayIndex = 0;
		$pathArray = explode(DIRECTORY_SEPARATOR, $path);
		for ($i = 0; $i < count($pathArray); $i++) {
			if ($pathArray[$i] == '..') {
				$removedDotPathArray[--$removedDotPathArrayIndex] = null;
			}
			else {
				$removedDotPathArray[$removedDotPathArrayIndex++] = $pathArray[$i];
			}
		}
		$removedDotPath = null;
		foreach ($removedDotPathArray as $oneRemovedDotPath) {
			if ($removedDotPath !== null) {
				$removedDotPath .= DIRECTORY_SEPARATOR;
			}
			$removedDotPath .= $oneRemovedDotPath;
		}
		return $removedDotPath;
	}
}
?>