#! ruby -Ks
#-- File_split3.rb
#-- File_split3.pi

require "File_unix"

#-- returns array of [ dir , basename , ext ]

class File
  def self.split3(path)
    path = self.unix path
    case path
    when /^(.*\/)(.*)(\..*?)$/ ; return [ $1 , $2, $3]
    when /^(.*\/)(.*)$/        ; return [ $1 , $2, ""]
    when /^(.*)(\..*?)$/       ; return [ "" , $1, $2]
    else                       ; return [ "" , path , ""]
    end
  end
end

if __FILE__ == $0

  p File.split3("G:/HTM/.html")     #=> ["G:/HTM/", "", ".html"]

raise
  p File.split3("G:/HTM/index.html")     #=> ["G:/HTM/", "index", ".html"]
  p File.split3("G:/HTM/index.")         #=> ["G:/HTM/", "index", "."]
  p File.split3("G:/HTM/index")          #=> ["G:/HTM/", "index", ""]
  p File.split3("G:/HTM/*.html")         #=> ["G:/HTM/", "*", ".html"]
  p File.split3("G:/HTM/*.")             #=> ["G:/HTM/", "*", "."]
  p File.split3("G:/HTM/index.html.bak") #=> ["G:/HTM/", "index.html", ".bak"]
  p File.split3("G:/HTM/")               #=> ["G:/HTM/", "", ""]

  p File.split3("index.html")     #=> ["", "index", ".html"]
  p File.split3("index.")         #=> ["", "index", "."]
  p File.split3("index")          #=> ["", "index", ""]
  p File.split3("*.html")         #=> ["", "*", ".html"]
  p File.split3("*.")             #=> ["", "*", "."]
  p File.split3("index.html.bak") #=> ["", "index.html", ".bak"]
  p File.split3("")               #=> ["", "", ""]

  p File.split3("/index.html")     #=> ["/", "index", ".html"]
  p File.split3("/index.")         #=> ["/", "index", "."]
  p File.split3("/index")          #=> ["/", "index", ""]
  p File.split3("/*.html")         #=> ["/", "*", ".html"]
  p File.split3("/*.")             #=> ["/", "*", "."]
  p File.split3("/index.html.bak") #=> ["/", "index.html", ".bak"]
  p File.split3("/")               #=> ["/", "", ""]

  p "----"

  p File.split("G:/HTM/index.html")     #=> ["G:/HTM", "index.html"]
  p File.split("G:/HTM/index.")         #=> ["G:/HTM", "index."]
  p File.split("G:/HTM/index")          #=> ["G:/HTM", "index"]
  p File.split("G:/HTM/*.html")         #=> ["G:/HTM", "*.html"]
  p File.split("G:/HTM/*.")             #=> ["G:/HTM", "*."]
  p File.split("G:/HTM/index.html.bak") #=> ["G:/HTM", "index.html.bak"]
  p File.split("G:/HTM/")               #=> ["G:/HTM", ""] # ver 1.6.7

  p File.split("index.html")     #=> [".", "index.html"]
  p File.split("index.")         #=> [".", "index."]
  p File.split("index")          #=> [".", "index"]
  p File.split("*.html")         #=> [".", "*.html"]
  p File.split("*.")             #=> [".", "*."]
  p File.split("index.html.bak") #=> [".", "index.html.bak"]
  p File.split("")               #=> [".", ""]

  p File.split("/index.html")     #=> ["/", "index.html"]
  p File.split("/index.")         #=> ["/", "index."]
  p File.split("/index")          #=> ["/", "index"]
  p File.split("/*.html")         #=> ["/", "*.html"]
  p File.split("/*.")             #=> ["/", "*."]
  p File.split("/index.html.bak") #=> ["/", "index.html.bak"]
  p File.split("/")               #=> ["/", ""]

end
