require 'phi'
require 'rgui/ui'
require 'dialogs'

MAX = 5
$anwser = nil
srand

# control
form = RGUI::Form.new(:form1, 'ăQ[')

form.width = 350
form.height = 90

start_btn = Phi::Button.new(form, :start_btn1, 'Q[Jn')
stop_btn = Phi::Button.new(form, :stop_btn1, 'Q[I')
stop_btn.enabled = false
hbox1 = UI::Hbox.new([start_btn, stop_btn], 5)
  
edit = Phi::Edit.new(form, :edit1, '')
answer_btn = Phi::Button.new(form, :answer_btn1, 'OK')
hbox2 = UI::Hbox.new([edit, answer_btn], 5)

vbox = UI::Vbox.new([hbox1, hbox2], 5)
form.add(vbox)


# method
def ok_msg(msg)
  Phi::message_dlg(msg, Phi::MT_INFORMATION, [Phi::MB_OK], 0)
end

def error_msg(msg)
  Phi::message_dlg(msg, Phi::MT_ERROR, [Phi::MB_OK], 0)
end

def start_game
  Phi::SCREEN.form1.start_btn1.enabled = false
  Phi::SCREEN.form1.stop_btn1.enabled = true
  $answer = rand(MAX)
  ok_msg(" 0`#{MAX - 1} ̐łB")
end

def stop_game
  Phi::SCREEN.form1.start_btn1.enabled = true
  Phi::SCREEN.form1.stop_btn1.enabled = false
  $answer = nil
  Phi::SCREEN.form1.edit1.text = ''
end

# event
answer_btn.on_click = proc do
  unless $answer.nil?
    if edit.text == $answer.to_s
      ok_msg('łB')
      stop_game
    else
      error_msg(" #{edit.text} ł͂܂B")
    end
  else
    error_msg("Q[JnĂB")
  end
end

start_btn.on_click = proc do
  if $answer.nil?
    start_game
  else
    error_msg('BUG')
  end
end

stop_btn.on_click = proc do
  if $answer
    stop_game
  else
    error_msg('BUG')
  end
end

form.on_resize = proc do
  form.layout
end

form.show
Phi.mainloop
