#!ruby -Ks

        ##
        ##  `[̃tH[
        ##
        ##  LbVAbvf[głB
        ##

require "phi"
require "rdb"
require "RGUI"
require "dialogs"
require "cct30"     ##  DB
require "cct33"     ##  shohin
include Phi

        ##
        ##  form
        ##
form = RGUI::Form.new :form_den_edit , "`[tH["
class << form
  attr :dataset,true
end

        ##
        ##  Upper Panel
        ##
panel1 = RGUI::Panel.new form , :panel1
panel1.align = Phi::AL_TOP
edits = [
    Label.new( panel1, :l1 , "  t "),
    Edit.new(  panel1, :edit_den_date ),
    Edit.new(  panel1, :edit_den_who  ),
    Label.new( panel1, :l2 , " l  "),
    Label.new( panel1, :l4 , "  v "),
    Edit.new(  panel1, :edit_den_goukei   ),
    Label.new( panel1, :l3 , "  ` "),
    Edit.new(  panel1, :edit_den_id   )
]
panel1.edit_den_date.width = form.canvas.text_width( 'w'*10 )
panel1.edit_den_id  .width = form.canvas.text_width( 'w'*4 )
panel1.add( RGUI::Hbox.new.add( edits ))
panel1.height = panel1.edit_den_who.height
form.client_width = edits.sum{ |c| c.width } + 10

        ##
        ##  lower panel
        ##
panel2 = RGUI::Panel.new form , :panel2
panel2.align = Phi::AL_BOTTOM
panel2.add( RGUI::Hbox.new.add(
  (btn_ok     =Button.new(panel2,:btn_ok     , "OK")),
  (btn_cancel =Button.new(panel2,:btn_cancel , "Cancel" )),
  (btn_save   =Button.new(panel2,:btn_save   , "Save" ))
))
panel2.height = btn_ok.height

        ##
        ##  grid
        ##
grid = DBGrid.new form , :grid
grid.align = Phi::AL_CLIENT

        ##
        ##  dataset for meisai
        ##
dataset = form.dataset = DB.new_query  # 2003-07-04()
datasource = DataSource.new dataset
grid.data_source = datasource

        ##
        ##  form methods
        ##
def form.goukei
  panel1.edit_den_goukei.text.to_i
end

def form.goukei= v
  panel1.edit_den_goukei.text = v.to_s
end

def form.den_id
  panel1.edit_den_id.text.to_i
end

def form.den_id= id
  panel1.edit_den_id.text = id.to_s
  if id == 0
    panel1.edit_den_date.text = DateTime.now.date.to_s
  else
    reload
  end
end

def form.reload
  id = den_id
  if id == 0
    ## den_clear
    return
  else
    panel1.edit_den_date.text = den_id_to_date(id).to_s
    panel1.edit_den_who.text  = den_id_to_who(id)
    self.goukei = den_id_to_goukei(id)
  end
        ##
  dataset.close
  dataset.cached_updates=true
  dataset.request_live=true
  dataset.sql.text = <<EOT
    SELECT *
    FROM ap01meisai_mei M
    WHERE (M.den_id = #{id})
EOT
  dataset.open
  dataset["den_id"].visible = false
  dataset["shohin_id"].visible = false
  dataset["meisai_id"].visible = false
  dataset["shohin_mei"].display_label = "i"
  dataset["tanka"].display_label = "P"
  dataset["suryo"].display_label = ""
  dataset["shokei"].display_label = "v"
end

def form.den_post
  fm = self
  pl = fm.panel1
  ds = dataset
  id = fm.den_id
    ##
  title = [ pl.edit_den_date.text , pl.edit_den_who.text ]
  meisai = []
  ds.first
  while not ds.eof?
    meisai << [ ds["shohin_id"].value , ds["suryo"].value , ds["tanka"].value]
    ds.next
  end
  if id == 0
    fm.den_id = insert_denpyo title,meisai
  else
    update_denpyo id,title,meisai
  end
  reload
  if defined? Phi::SCREEN.form_den_grid
    fm = Phi::SCREEN.form_den_grid
    fm.refresh
  end
end

def form.den_clear
  dataset.first
  while not dataset.eof?
    dataset.delete
  end
  self.goukei = 0
end

def form.den_haiki
  if Phi::MR_YES == Phi.message_dlg ( "̓`[pĂ悢ł",
        Phi::MT_CONFIRMATION, [Phi::MB_YES,Phi::MB_NO] )
    print "delete_denpyo #{self.den_id}\n"
  end
end

        ##
        ##  menu
        ##
Phi.new_menu form, :menu, [
      Phi.new_item( '&File' , '' , :mi_file ).add(
        Phi.new_item( 'e&xit' , 'Ctrl+Y', :mi_exit )
      ),
      Phi.new_item( '`[(&D)' , '' , :mi_den ).add(
        Phi.new_item( 'ۑ(&S)',   'Ctrl+S' , :mi_den_update ),
        Phi.new_item( 'NA(&C)', 'Ctrl+C' , :mi_den_clear ),
        Phi.new_item( 'p(&H)',   'Ctrl+H' , :mi_den_haiki ),
        Phi.new_item( '(&D)',   'Ctrl+D' , :mi_den_dup )
      )
]
form.menu_attr_flatten

        ##
        ##  event handlers
        ##
form.mi_exit.on_click       = proc{ exit }
form.mi_den_clear.on_click  = proc{ form.den_clear }
form.mi_den_dup.on_click    = proc{ form.den_id = 0 }
form.mi_den_haiki.on_click  = proc{ form.den_haiki }
form.mi_den_update.on_click = proc{ form.den_post }
btn_ok.on_click             = proc{ form.den_post ; form.close }
btn_save.on_click           = proc{ form.den_post }
btn_cancel.on_click         = proc{ form.close }

        ##
        ##  vIɌvZnh
        ##
        ##  on_data_change ͏㉺͔邪Eł͔ȂB
        ##  [ret]ƂɂB
        ##  ]ȃ^C~OłBAȂȂ낵B
        ##
datasource.on_data_change = proc {
  if [RDB::DS_EDIT, RDB::DS_INSERT] .include? dataset.state
    shokei_old = dataset["shokei"].to_i
    shokei_new = dataset["suryo"].to_i * dataset["tanka"].to_i
    if shokei_old != shokei_new
       form.goukei += ( shokei_new - shokei_old )
       dataset["shokei"] = shokei_new
    end
  end
}

        ##
        ##  Obh̏iNbNƂ
        ##  icãObhJāishow_modalj
        ##  Iꂽ炻̏iAihcZbgB
        ##
select_shohin = proc{
  shohin_id = dataset["shohin_id"].value
  fm = Phi::SCREEN.form_shohin
  mr,id,code,name,tanka = fm.select_shohin shohin_id
  if mr == Phi::MR_OK
    old_state = dataset.state
    dataset.edit if old_state == RDB::DS_BROWSE
      dataset["shohin_id"] = id
      dataset["shohin_code"] = code
      dataset["shohin_mei"] = name
      dataset["tanka"] = tanka
    dataset.post if old_state == RDB::DS_BROWSE
  end
}

grid.on_dbl_click = proc{
  if grid.selected_field.field_name == "SHOHIN_MEI"
    select_shohin.call
  end
}

grid.on_key_press = proc{ |sender,key|
  case key
  when 13       #   "\n"
    if grid.selected_field.field_name == "SHOHIN_MEI"
      select_shohin.call
    end
  end
}

        ##
        ##  display form
        ##
panel1.layout
panel2.layout

if __FILE__ == $0
  form.den_id = DB.lookup "den_id","ap01den",nil
  form.show
  Phi.mainloop
end
