require 'phi'

class MyDialog < Phi::Form

  def initialize(com_name, capt)
    super(com_name, capt)
    self.border_style = Phi::BS_DIALOG
    self.width = 300
    self.height = 100
    self.position = Phi::PO_MAIN_FORM_CENTER

    margin = 10
    
    ok = Phi::Button.new(self, :ok1, 'OK')
    cancel = Phi::Button.new(self, :cancel1, 'LZ')
    edit = Phi::Edit.new(self, :edit1, '')

    ok.modal_result = Phi::MR_OK
    cancel.modal_result = Phi::MR_CANCEL

    edit.top = margin
    edit.left = margin
    edit.width = self.width - margin * 2 - 5

    ok.top = edit.top + edit.height + margin
    cancel.top = ok.top

    cancel.left = self.width - cancel.width - margin - 5
    ok.left = cancel.left - ok.width - margin

    self.on_show = proc do
      edit.set_focus
    end
  end
  
end

form = Phi::Form.new(:form1, 'formł')
button = Phi::Button.new(form, :button1, 'hoge')
form.height = 95
label = Phi::Label.new(form, :label1, '')
button.align = Phi::AL_TOP
label.align = Phi::AL_CLIENT
label.color = Phi::CL_WHITE

button.on_click = proc do
  dlg = MyDialog.new(:dlg1, '͂ĂB')
  result = dlg.show_modal
  case result
  when Phi::MR_OK
    if dlg.edit1.text != ''
      label.caption = dlg.edit1.text
    end
  when Phi::MR_CANCEL
    label.caption = 'LZ܂B'
  end
end
form.show
Phi.mainloop
