$KCODE = 'SJIS'

begin
  require 'conf_opt'
rescue LoadError
  DELPHI_VERSION = 6
  DELPHI_EDITION = 'pro'
  DIR_PAIR_LIST = [
  ]
end

if $0 =~ /deconf/
  DELPHI_VERSION = 6
  DELPHI_EDITION = 'pro'

  DIR_PAIR_LIST.each do |pair|
    pair.push pair.shift
  end
end

DELPHI_PACKAGE = {
  'd6ent' => <<EOT,
vcl;rtl;dbrtl;adortl;vcldb;vclx;bdertl;vcldbx;ibxpress;dsnap;cds;bdecds;qrpt;teeui;teedb;tee;dss;teeqr;visualclx;visualdbclx;dsnapcrba;dsnapcon;VclSmp;vclshlctrls;vclie;vcljpg;xmlrtl;inet;inetdbbde;inetdbxpress;inetdb;nmfast;webdsnap;websnap;dbexpress;dbxcds;indy;dclOffice2k
EOT
  'd6pro' => <<EOT,
vcl;rtl;dbrtl;adortl;vcldb;vclx;bdertl;vcldbx;ibxpress;qrpt;teeui;teedb;tee;teeqr;visualclx;visualdbclx;VclSmp;vclshlctrls;vclie;vcljpg;xmlrtl;inet;inetdbbde;inetdbxpress;inetdb;dbexpress;dbxcds;indy;dclOffice2k
EOT
  'd6per' => <<EOT,
vcl;rtl;vclx;VclSmp;vclshlctrls;vcljpg
EOT
  'd7pro' => <<EOT,
vcl;rtl;vclx;indy;vclie;xmlrtl;inetdbbde;inet;inetdbxpress;dbrtl;soaprtl;dsnap;VclSmp;dbexpress;vcldb;dbxcds;inetdb;bdertl;vcldbx;adortl;teeui;teedb;tee;ibxpress;visualclx;visualdbclx;vclactnband;vclshlctrls;IntrawebDB_50_70;Intraweb_50_70;Rave50CLX;Rave50VCL;dclOfficeXP
EOT
  'd9pro' => <<EOT,
rtl;vcl;vcldb;dbrtl;vclx;adortl;dbxcds;dbexpress;vclib;ibxpress;IntrawebDB_72_90;Intraweb_72_90;xmlrtl;vclie;inet;inetdbbde;inetdbxpress;dclOfficeXP;VclSmp;soaprtl;dsnap;inetdb;bdertl;vcldbx;vclactnband;vclshlctrls;teeui;teedb;tee
EOT
}["d#{DELPHI_VERSION}#{DELPHI_EDITION[0,3].downcase}"].chomp

REPLACE_LU = '-LU' + DELPHI_PACKAGE
REPLACE_Packages = 'Packages=' + DELPHI_PACKAGE

def filter(glob_pattern)
  Dir.glob(glob_pattern){|entry|
    next if /__/ =~ entry
    puts entry
    backup = entry + '~'
    File.rename entry, backup
    open(backup){|i|
    open(entry, 'w'){|o|
      yield i, o
    }}
  }
end

def replace_dir(line)
  DIR_PAIR_LIST.each do |pair|
    line.gsub!(Regexp.new(Regexp.escape(pair[0])+'\b', true)){ pair[1] }
  end
end

Proc_ruby_define = proc do |opt|
  list = opt.split(/;/)
  list.reject!{|i| /^RUBY/ =~ i }
  list.push("RUBY18") if RUBY_VERSION >= '1.8.0'
  list.join(';')
end

def bdsproj_filter
  filter('**/*.bdsproj'){|i, o|
    while line = i.gets
      next if /^$/ =~ line
      line.sub!(%r[<Directories Name="Packages">.*?(?=</Directories>)], %Q[<Directories Name="Packages">#{DELPHI_PACKAGE}])
      line.sub!(%r[<Directories Name="Conditionals">.*?(?=</Directories>)], &Proc_ruby_define)
      replace_dir(line)
      o.print line
    end
  }
end

def cfg_filter
  filter('**/*.cfg'){|i, o|
    while line = i.gets
      next if /^$/ =~ line
      line.sub!(/^-LU.*/, REPLACE_LU)
      line.sub!(/^-D(.*)/, &Proc_ruby_define)
#     line.sub!(/^-\$J\+/, '-$J-')
      replace_dir(line)
      o.print line
    end
  }
end

def dof_filter
  filter('**/*.dof'){|i, o|
    while line = i.gets
      next if /^$/ =~ line
      line.sub!(/^Packages=.*/, REPLACE_Packages)
      line.sub!(/^Conditionals=(.*)/, &Proc_ruby_define)
#     line.sub!(/^J=1/, 'J=0')
      replace_dir(line)
      o.print line
    end
  }
end

def configure
##require "required"
##p required(/conf_opt/i)
##p [:DELPHI_VERSION,DELPHI_VERSION,:DELPHI_EDITION,DELPHI_EDITION,:DIR_PAIR_LIST,DIR_PAIR_LIST]
  bdsproj_filter
  cfg_filter
  dof_filter
p [:DELPHI_VERSION,DELPHI_VERSION,:DELPHI_EDITION,DELPHI_EDITION,:DIR_PAIR_LIST,DIR_PAIR_LIST]
##p [:required,required(/conf_opt/i)]
end

if $0 == __FILE__
  configure
end
