unit uAreaSeries;

interface

uses
  TeEngine,
  Chart,
  Series,
  Rubies;

var
  cAreaSeries: Tvalue;

function ap_cAreaSeries: Tvalue;
function ap_iAreaSeries(real: TAreaSeries; owner: Tvalue): Tvalue;
procedure Init_AreaSeries;

implementation

uses
  uChartSeries,
  Classes,
  uDefUtils, 
  Pythia;

function ap_cAreaSeries: Tvalue;
begin
  result := cAreaSeries;
end;

procedure AreaSeries_setup(obj: Tvalue; real: TAreaSeries);
begin
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function AreaSeries_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  //EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function AreaSeries_alloc(This: Tvalue; real: TAreaSeries): Tvalue;
begin
  result := ChildAlloc(This, real);
  AreaSeries_setup(result, real);
end;

function ap_iAreaSeries(real: TAreaSeries; owner: Tvalue): Tvalue;
begin
  result := AreaSeries_alloc(cAreaSeries, real);
  ap_owner(result, owner);
end;

function ap_iAreaSeries_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iAreaSeries(TAreaSeries(AControl), owner);
end;

function AreaSeries_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TAreaSeries;
begin
  real := TAreaSeries.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  AreaSeries_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_AreaSeries;
begin
  cAreaSeries := DefinePersistentClass(ap_mPhi, TAreaSeries, cChartSeries, ap_iAreaSeries_v);
  rb_define_method(cAreaSeries, 'event_handle', @AreaSeries_event_handle, 1);
  DefineSingletonMethod(cAreaSeries, 'new', AreaSeries_new);
end;

end.
