unit uChart;

interface

uses
  Chart,
  Rubies;

var
  cChart: Tvalue;

function ap_cChart: Tvalue;
function ap_iChart(real: TChart; owner: Tvalue): Tvalue;
procedure Init_ChartClass;

implementation

uses
  TeEngine,
  Series,
  Classes,
  uChartSeriesList,
  uChartSeries,
  uDefUtils,
  uPieSeries,
  Pythia;

function ap_cChart: Tvalue;
begin
  result := cChart;
end;

procedure Chart_setup(obj: Tvalue; real: TChart);
begin
rb_p(ap_String('Chart_setup'));
//  rb_iv_set(obj, '@series_list', ap_iChartSeriesList(real.SeriesList, obj));
//  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function Chart_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  //EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Chart_alloc(This: Tvalue; real: TChart): Tvalue;
begin
  result := ChildAlloc(This, real);
  Chart_setup(result, real);
end;

function ap_iChart(real: TChart; owner: Tvalue): Tvalue;
begin
  result := Chart_alloc(cChart, real);
  ap_owner(result, owner);
end;

function ap_iChart_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iChart(TChart(AControl), owner);
end;

function Chart_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TChart;
begin
  real := TChart.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Chart_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;


function Chart_get_series(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TChart;
  series: TChartSeries;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  series := real.Series[dl_Integer(argv[0])];
  if series is TPieSeries
    then result := ap_iPieSeries(TPieSeries(series),This)
    else result := ap_iChartSeries(series,This);
end;

//function Chart_add_series(This, series: Tvalue): Tvalue; cdecl;
//var
//  real: TChart;
//begin
//  real := ap_data_get_struct(This);
//  real.AddSeries(TChartSeries(ap_data_get_struct(series)));
//end;
//AddSeries \bh́CVnR|[lg`[gɒǉ܂B́CSeries.
//ParentChartvpeB`[gɐݒ肷̂Ƃ܂ƂłB
//LineSeries1.ParentChart := Chart1;
//Series sɒǉꍇ́CParentChart vpeBgpĂB


procedure Init_ChartClass;
begin
rb_p(ap_String('Init_ChartClass'));
  PhiStart;
rb_p(ap_mPhi);
rb_p(ap_cControl);
  cChart := DefinePersistentClass(ap_mPhi, TChart, ap_cWinControl, ap_iChart_v);
//
//  cChart := DefinePersistentClass(ap_mPhi, TChart, ap_cPanel, ap_iChart_v);
//vpeB caption ݂܂ (Phi::DelphiError)
  rb_define_method(cChart, 'event_handle', @Chart_event_handle, 1);
  DefineSingletonMethod(cChart, 'new', Chart_new);
  DefineIndexer(cChart, 'series', @Chart_get_series, nil);
  //rb_define_method(cChart, 'add_series', @Chart_add_series, 1);
end;

end.
