unit uCustomBarSeries;

interface

uses
  TeEngine,
  Chart,
  Series,
  Rubies;

var
  cCustomBarSeries: Tvalue;

function ap_cCustomBarSeries: Tvalue;
function ap_iCustomBarSeries(real: TCustomBarSeries; owner: Tvalue): Tvalue;
procedure Init_CustomBarSeries;

implementation

uses
  uChartSeries,
  Classes,
  uDefUtils, 
  Pythia;

function ap_cCustomBarSeries: Tvalue;
begin
  result := cCustomBarSeries;
end;

procedure CustomBarSeries_setup(obj: Tvalue; real: TCustomBarSeries);
begin
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function CustomBarSeries_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  //EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function CustomBarSeries_alloc(This: Tvalue; real: TCustomBarSeries): Tvalue;
begin
  result := ChildAlloc(This, real);
  CustomBarSeries_setup(result, real);
end;

function ap_iCustomBarSeries(real: TCustomBarSeries; owner: Tvalue): Tvalue;
begin
  result := CustomBarSeries_alloc(cCustomBarSeries, real);
  ap_owner(result, owner);
end;

function ap_iCustomBarSeries_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iCustomBarSeries(TCustomBarSeries(AControl), owner);
end;

function CustomBarSeries_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TCustomBarSeries;
begin
  real := TCustomBarSeries.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  CustomBarSeries_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_CustomBarSeries;
begin
  cCustomBarSeries := DefinePersistentClass(ap_mPhi, TCustomBarSeries, cChartSeries, ap_iCustomBarSeries_v);
  rb_define_method(cCustomBarSeries, 'event_handle', @CustomBarSeries_event_handle, 1);
  DefineSingletonMethod(cCustomBarSeries, 'new', CustomBarSeries_new);
end;

end.
