unit uPieSeries;

interface

uses
  TeEngine,
  Chart,
  Series,
  Rubies;

var
  cPieSeries: Tvalue;

function ap_cPieSeries: Tvalue;
function ap_iPieSeries(real: TPieSeries; owner: Tvalue): Tvalue;
procedure Init_PieSeries;

implementation

uses
  uChartSeries,
  Classes,
  uDefUtils, 
  Pythia;

function ap_cPieSeries: Tvalue;
begin
  result := cPieSeries;
end;

procedure PieSeries_setup(obj: Tvalue; real: TPieSeries);
begin
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function PieSeries_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  //EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function PieSeries_alloc(This: Tvalue; real: TPieSeries): Tvalue;
begin
  result := ChildAlloc(This, real);
  PieSeries_setup(result, real);
end;

function ap_iPieSeries(real: TPieSeries; owner: Tvalue): Tvalue;
begin
  result := PieSeries_alloc(cPieSeries, real);
  ap_owner(result, owner);
end;

function ap_iPieSeries_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPieSeries(TPieSeries(AControl), owner);
end;

function PieSeries_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TPieSeries;
begin
  real := TPieSeries.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  PieSeries_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_PieSeries;
begin
//  OutputConstSetType(mPhi, TypeInfo(TBevelCut));
  cPieSeries := DefinePersistentClass(ap_mPhi, TPieSeries, cChartSeries, ap_iPieSeries_v);
  rb_define_method(cPieSeries, 'event_handle', @PieSeries_event_handle, 1);
  DefineSingletonMethod(cPieSeries, 'new', PieSeries_new);
end;

end.
