unit uIdFTP;

interface

uses Classes, IdFTP, Rubies;

var
  cIdFTP: Tvalue;

function ap_cIdFTP: Tvalue;
function ap_iIdFTP(real: TIdFTP; owner: Tvalue): Tvalue;
procedure Init_IdFTP;

implementation

uses
  SysUtils, uDefUtils, Pythia, IdHandle, uIndy, uIdTCPClient;

function ap_cIdFTP: Tvalue;
begin
  result := cIdFTP;
end;

procedure IdFTP_setup(obj: Tvalue; real: TIdFTP);
begin
  ap_set_child_attr_module(obj);
end;

function IdFTP_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function IdFTP_alloc(This: Tvalue; real: TIdFTP): Tvalue;
begin
  result := ChildAlloc(This, real);
  IdFTP_setup(result, real);
end;

function ap_iIdFTP(real: TIdFTP; owner: Tvalue): Tvalue;
begin
  result := IdFTP_alloc(cIdFTP, real);
  ap_owner(result, owner);
end;

function ap_iIdFTP_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iIdFTP(TIdFTP(obj), owner);
end;

function IdFTP_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TIdFTP;
begin
  real := TIdFTP.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  IdFTP_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

procedure Init_IdFTP;
begin
//  cIdFTP := rb_define_class_under(mIndy, 'IdFTP', cIdTCPClient);
//  DefineProp(cIdFTP, TIdFTP);
  cIdFTP := DefinePersistentClass(mIndy, TIdFTP, cIdTCPClient, ap_iIdFTP_v);
  DefineSingletonMethod(cIdFTP, 'new', IdFTP_new);
  rb_define_method(cIdFTP, 'event_handle', @IdFTP_event_handle, 1);
end;

end.
