unit uPointInfo;

interface

uses
{$IFDEF LINUX}
  Types,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  Rubies, PathUtils;

{
  // ̃pX
  TPathInfo = record
    Count : Integer;         // W̐
    Points: array of TPoint; // W
    Types : array of Byte;   // W̑
  end;

  TFigureType = (ptMoveTo, ptLineTo, ptBezierTo);

  // TPath ̍W̌^
  TPointInfo = record
    Point: TPoint;         // W
    Figure: TFigureType;   // }`̎(ptMove, prLineTo, ptBezierTo)
    CloseFigure: Boolean;  // }`̍WŕĂ邱Ƃ\
  end;

}
var
  sPointInfo: Tvalue;

function PointInfo_alloc(real: TPointInfo): Tvalue;
procedure PointInfo_assign(var real: TPointInfo; v: Tvalue);
procedure Init_PointInfo;

implementation

uses Pythia;

function PointInfo_alloc(real: TPointInfo): Tvalue;
var
  ary: Tvalue;
begin
  ary := rb_ary_new;
  rb_ary_push(ary, ap_iPoint(real.Point, Qnil));
  rb_ary_push(ary, ap_Fixnum(Ord(real.Figure)));
  rb_ary_push(ary, ap_bool(real.CloseFigure));
  result := rb_struct_alloc(sPointInfo, ary);
end;

var
  id_to_a: Tvalue;

procedure PointInfo_assign(var real: TPointInfo; v: Tvalue);
var
  ary: Tvalue;
begin
  ary := rb_funcall2(v, id_to_a, 0, nil);
  real.Point := TPoint(ap_data_get_struct(rb_ary_shift(ary))^);
  real.Figure := TFigureType(dl_Integer(rb_ary_shift(ary)));
  real.CloseFigure := dl_Boolean(rb_ary_shift(ary));
end;

const
  props: array[0..2] of PChar = (
    'Point',
    'Figure',
    'CloseFigure'
  );

procedure Init_PointInfo;
var
  ary: Tvalue;
  i: Integer;
begin
  id_to_a := rb_intern('to_a');
  ary := rb_ary_new;
  rb_ary_push(ary, rb_str_new2('PointInfo'));
  for i := low(props) to high(props) do
    rb_ary_push(ary, ap_String(LowerCase1(props[i])));
  sPointInfo := rb_apply(ap_cStruct, rb_intern('new'), ary);
  rb_global_variable(@sPointInfo);
end;

end.
