unit uDBNavigator;

interface

uses Rubies;

var
  cDBNavigator: Tvalue;

procedure Init_DBNavigator;

implementation

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  uDefUtils, Pythia, uRDB;

procedure DBNavigator_setup(obj: Tvalue; real: TDBNavigator);
begin
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBNavigator_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBNavigator_alloc(This: Tvalue; real: TDBNavigator): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBNavigator_setup(result, real);
end;

function ap_iDBNavigator(real: TDBNavigator; owner: Tvalue): Tvalue;
begin
  result := DBNavigator_alloc(cDBNavigator, real);
  ap_owner(result, owner);
end;

function ap_iDBNavigator_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBNavigator(TDBNavigator(AControl), owner)
end;

function DBNavigator_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDBNavigator;
begin
  real := TDBNavigator.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);

  ap_obj_call_init(result, argc, argv);
end;

function DBNavigator_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBNavigator;
begin
  real := ap_data_get_struct(This);
  real.DataSource := TDataSource(ap_data_get_struct(v));
  result := v;
end;

procedure Init_DBNavigator;
begin
  cDBNavigator := DefinePersistentClass(mRDB, TDBNavigator, ap_cWinControl, ap_iDBNavigator_v);
  rb_define_method(cDBNavigator, 'event_handle', @DBNavigator_event_handle, 1);
  DefineSingletonMethod(cDBNavigator, 'new', DBNavigator_new);
  DefineAttrSet(cDBNavigator, 'data_source', DBNavigator_set_data_source);
end;

end.
