unit uDataSet;

{$I heverdef.inc}

interface

uses
  Classes, DB, Rubies;

var
  cDataSet: Tvalue;

function ap_cDataSet: Tvalue;
function RDBDataSetTmpAllocFuncList: TList;
function DataSetTmpAlloc(Dataset: TDataSet; owner: Tvalue): Tvalue;
procedure DataSet_setup(This: Tvalue; real: TDataSet);
function DataSet_alloc(This: Tvalue; real: TDataSet): Tvalue;
procedure Init_DataSet;

implementation

uses
  SysUtils,
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  uDefUtils, Pythia,
{$IFDEF DELPHI6_UP}
  Variants,
{$ENDIF}
  RDBHandle, uRDB,
  uDataSource, uField, uFieldDef;

function ap_cDataSet: Tvalue;
begin
  result := cDataSet;
end;

function dl_DataSet(This: Tvalue): TDataSet;
begin
  result := ap_data_get_struct(This);
end;

type
  TDataSetTmpAllocFunc = function(Dataset: TDataSet; owner: Tvalue): Tvalue;
var
  FDataSetTmpAllocFuncList: TList;

function RDBDataSetTmpAllocFuncList: TList;
begin
  Result := FDataSetTmpAllocFuncList;
end;

function DataSetTmpAlloc(Dataset: TDataSet; owner: Tvalue): Tvalue;
var
  i: Integer;
  Func: TDataSetTmpAllocFunc;
begin
  Result := Qnil;
  for i := 0 to FDataSetTmpAllocFuncList.Count-1 do
  begin
    Func := TDataSetTmpAllocFunc(FDataSetTmpAllocFuncList[i]);
    Result := Func(Dataset, owner);
    if Result <> Qnil then Break;
  end;
end;

procedure DataSet_setup(This: Tvalue; real: TDataSet);
begin
//see: [ap-dev:0625]
  rb_iv_set(This, '@field_defs', ap_iFieldDefs(real.FieldDefs, This));
//rb_iv_set(This, '@index_defs', ap_iIndexDefs(real.IndexDefs, This));
//    AssignPropMethod(real, [Handle]);
end;

function DataSet_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

procedure CompoFree(real: TComponent); cdecl;
begin
  try
    real.tag := 0;
    if csDestroying in real.ComponentState then
      PhiObjectList.Extract(real)
    else
      PhiObjectList.Remove(real);
  except
    on E: Exception do;
  end;
end;

procedure DataSet_free(real: TDataSet); cdecl;
begin
  if real.Active then real.Close;
  CompoFree(real);
end;

// CompoAlloc modified
function DataSet_alloc(This: Tvalue; real: TDataSet): Tvalue;
begin
  if real = nil then begin result := Qnil; exit; end;
  PhiObjectList.Add(real);
  result := rb_data_object_alloc(This, real, nil, @DataSet_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function DataSet_aref(This, p: Tvalue): Tvalue; cdecl;
var
  n: Integer;
  real: TDataSet;
  field: TField;
begin
  real := dl_DataSet(This);
  field := nil;

  try  //[ap-dev:0825]

  case RTYPE(p) of
  T_STRING:
      field := real.FindField(dl_String(p));
  T_FIXNUM:
    begin
      n := FIX2INT(p);
      if (n < 0) or (real.Fields.Count <= n) then
        ap_raise(ap_eIndexError, sOut_of_range);
      field := real.Fields[n];
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;

  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;

  if field = nil then
    result := Qnil
  else
    result := ap_iField(field, This);
end;

function DataSet_aset(This, p, v: Tvalue): Tvalue; cdecl;
var
  n: Integer;
  real: TDataSet;
  field: TField;
begin
  real := dl_DataSet(This);
  field := nil;

  case RTYPE(p) of
  T_STRING:
      field := real.FindField(dl_String(p));
  T_FIXNUM:
    begin
      n := FIX2INT(p);
      if (n < 0) or (real.Fields.Count <= n) then
        ap_raise(ap_eIndexError, sOut_of_range);
      field := real.Fields[n];
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;

  if field = nil then
    result := Qnil
  else
  begin
    result := ap_iField(field, This);
    Field_ap_data_assign(field , v);
  end;
end;

function DataSet_get_fields(This: Tvalue): Tvalue; cdecl;
begin
  result := TmpAlloc(cFields, dl_DataSet(This).Fields);
end;

function DataSet_get_state(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(Ord(dl_DataSet(This).State));
end;

function DataSet_close(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Close;
  result := This;
end;

function DataSet_open(This: Tvalue): Tvalue; cdecl;
begin
//rb_p(ap_String('DataSet_open'));
  dl_DataSet(This).Open;
  result := This;
end;

function DataSet_edit(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Edit;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_post(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Post;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_append(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Append;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_insert(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Insert;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_delete(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Delete;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_first(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).First;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_last(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Last;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_next(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Next;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_prior(This: Tvalue): Tvalue; cdecl;
begin
  try
    dl_DataSet(This).Prior;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function DataSet_move_by(This, v: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
  try
    result := INT2FIX(dl_DataSet(This).MoveBy(FIX2INT(v)));
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function DataSet_locate(This, fields, values, options: Tvalue): Tvalue; cdecl;
var
  v: Tvalue;
  i: Integer;
  n: Integer;
  len: Integer;
  ptr: Pvalue;
  A: Variant;
  field: TField;
  ary: Tvalue;
  Opts: TLocateOptions;
  real: TDataSet;
begin
  real := dl_DataSet(This);

  v := values;
  case RTYPE(v) of
  T_ARRAY:
    begin
      len := ap_ary_len(v);
      ptr := ap_ary_ptr(v);
      A := VarArrayCreate([0, len-1], varVariant);
      for i := 0 to len-1 do
      begin
        v := ptr^;
        case RTYPE(v) of
        T_STRING: A[i] := string(dl_String(v));
        T_FIXNUM: A[i] := FIX2INT(v);
        T_BIGNUM: A[i] := NUM2INT(v);
        T_FLOAT : A[i] := NUM2DBL(v);
        T_TRUE  : A[i] := True;
        T_FALSE : A[i] := False;
        T_DATA  :
          begin
            ap_data_get_object(v, TField, field);
            A[i] := field.AsString;
          end;
        else
          ap_raise(ap_eArgError, sWrong_arg_type);
        end;
        Inc(ptr);
      end;
    end;
  T_STRING: A := string(dl_String(v));
  T_FIXNUM: A := FIX2INT(v);
  T_BIGNUM: A := NUM2INT(v);
  T_FLOAT : A := NUM2DBL(v);
  T_TRUE  : A := True;
  T_FALSE : A := False;
  T_DATA  :
    begin
      ap_data_get_object(v, TField, field);
      A := field.AsString;
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;

  ary := options;
  Check_Type(ary, T_ARRAY);
  len := ap_ary_len(ary);
  ptr := ap_ary_ptr(ary);
  Opts := [];
  while len > 0 do
  begin
    n := FIX2INT(ptr^);
    try
      Include(Opts, TLocateOption(n));
    except
      ap_raise(ap_eIndexError, sOut_of_range);
    end;
    Dec(len);
    Inc(ptr);
  end;

  result := Qnil;
  try
    result := ap_bool(real.Locate(dl_String(fields), A, Opts));
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function DataSet_get_bof(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_DataSet(This).Bof);
end;

function DataSet_get_eof(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_DataSet(This).Eof);
end;

function DataSet_bookmark(This: Tvalue): Tvalue; cdecl;
var
  real: TDataSet;
  Bookmark: TBookmark;
begin
  if rb_block_given_p = 0 then ap_raise(ap_eDatabaseError, 'need block');
  real := dl_DataSet(This);
  Bookmark := real.GetBookmark;
  try
    result := rb_ensure(@rb_yield, This, @retnil, This);
  finally
    real.GotoBookmark(Bookmark);
    real.FreeBookmark(Bookmark);
  end;
end;

function DataSet_disable_controls(This: Tvalue): Tvalue; cdecl;
var
  real: TDataSet;
begin
  if rb_block_given_p = 0 then ap_raise(ap_eDatabaseError, 'need block');
  real := dl_DataSet(This);
  real.DisableControls;
  try
    result := rb_ensure(@rb_yield, This, @retnil, This);
  finally
    real.EnableControls;
  end;
end;

function DataSet_refresh(This: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_DataSet(This).Refresh;
end;

function DataSet_cancel(This: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_DataSet(This).Cancel;
end;
(**** str_my_class made by ap_src_maker ****)
type
TPhi_DataSet = class(TDataSet)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function DataSet_bookmark_valid(This, Bookmark : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_Bookmark : TBookmark;
begin
  real := ap_data_get_struct(This);
  dlv_Bookmark := ap_data_get_struct(Bookmark);
  result := ap_Bool(real.BookmarkValid( dlv_Bookmark ));
end;

function DataSet_check_browse_mode(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.CheckBrowseMode;
  result := This;
end;

function DataSet_clear_fields(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.ClearFields;
  result := This;
end;

function DataSet_controls_disabled(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.ControlsDisabled);
end;

function DataSet_compare_bookmarks(This, Bookmark1, Bookmark2 : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_Bookmark1 : TBookmark;
  dlv_Bookmark2 : TBookmark;
begin
  real := ap_data_get_struct(This);
  dlv_Bookmark1 := ap_data_get_struct(Bookmark1);
  dlv_Bookmark2 := ap_data_get_struct(Bookmark2);
  result := ap_Integer(real.CompareBookmarks( dlv_Bookmark1, dlv_Bookmark2 ));
end;

function DataSet_create_blob_stream(This, Field, Mode : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_Field : TField;
  dlv_Mode : TBlobStreamMode;
begin
  real := ap_data_get_struct(This);
  dlv_Field := ap_data_get_struct(Field);
  dlv_Mode := TBlobStreamMode(dl_Integer(Mode));
  result := ap_iStream(real.CreateBlobStream( dlv_Field, dlv_Mode ),This);
end;

function DataSet_cursor_pos_changed(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.CursorPosChanged;
  result := This;
end;

function DataSet_enable_controls(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.EnableControls;
  result := This;
end;

function DataSet_field_by_name(This, FieldName : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_FieldName : string;
begin
  real := ap_data_get_struct(This);
  dlv_FieldName := dl_String(FieldName);
  result := ap_iField(real.FieldByName( dlv_FieldName ),This);
end;

function DataSet_find_field(This, FieldName : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_FieldName : string;
begin
  real := ap_data_get_struct(This);
  dlv_FieldName := dl_String(FieldName);
  result := ap_iField(real.FindField( dlv_FieldName ),This);
end;

function DataSet_find_first(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.FindFirst);
end;

function DataSet_find_last(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.FindLast);
end;

function DataSet_find_next(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.FindNext);
end;

function DataSet_find_prior(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.FindPrior);
end;

function DataSet_free_bookmark(This, Bookmark : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_Bookmark : TBookmark;
begin
  real := ap_data_get_struct(This);
  dlv_Bookmark := ap_data_get_struct(Bookmark);
  real.FreeBookmark( dlv_Bookmark );
  result := This;
end;

function DataSet_get_current_record(This, Buffer : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_Buffer : PChar;
begin
  real := ap_data_get_struct(This);
  dlv_Buffer := ap_data_get_struct(Buffer);
  result := ap_Bool(real.GetCurrentRecord( dlv_Buffer ));
end;

function DataSet_get_detail_data_sets(This, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_List : TList;
begin
  real := ap_data_get_struct(This);
  dlv_List := ap_data_get_struct(List);
  real.GetDetailDataSets( dlv_List );
  result := This;
end;

function DataSet_get_detail_link_fields(This, MasterFields, DetailFields : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_MasterFields : TList;
  dlv_DetailFields : TList;
begin
  real := ap_data_get_struct(This);
  dlv_MasterFields := ap_data_get_struct(MasterFields);
  dlv_DetailFields := ap_data_get_struct(DetailFields);
  real.GetDetailLinkFields( dlv_MasterFields, dlv_DetailFields );
  result := This;
end;

function DataSet_get_blob_field_data(This, FieldNo, Buffer : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_FieldNo : Integer;
  dlv_Buffer : TBlobByteData;
begin
  real := ap_data_get_struct(This);
  dlv_FieldNo := dl_Integer(FieldNo);
  dlv_Buffer := ap_data_get_struct(Buffer);
  result := ap_Integer(real.GetBlobFieldData( dlv_FieldNo, dlv_Buffer ));
end;

function DataSet_get_field_data(This, Field, Buffer : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_Field : TField;
  dlv_Buffer : Pointer;
begin
  real := ap_data_get_struct(This);
  dlv_Field := ap_data_get_struct(Field);
  dlv_Buffer := ap_data_get_struct(Buffer);
  result := ap_Bool(real.GetFieldData( dlv_Field, dlv_Buffer ));
end;

function DataSet_get_field_list(This, List, FieldNames : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_List : TList;
  dlv_FieldNames : string;
begin
  real := ap_data_get_struct(This);
  dlv_List := ap_data_get_struct(List);
  dlv_FieldNames := dl_String(FieldNames);
  real.GetFieldList( dlv_List, dlv_FieldNames );
  result := This;
end;

function DataSet_get_field_names(This, List : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_List : TStrings;
begin
  real := ap_data_get_struct(This);
  dlv_List := ap_data_get_struct(List);
  real.GetFieldNames( dlv_List );
  result := This;
end;

function DataSet_goto_bookmark(This, Bookmark : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_Bookmark : TBookmark;
begin
  real := ap_data_get_struct(This);
  dlv_Bookmark := ap_data_get_struct(Bookmark);
  real.GotoBookmark( dlv_Bookmark );
  result := This;
end;

function DataSet_is_empty(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.IsEmpty);
end;

function DataSet_is_linked_to(This, DataSource : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_DataSource : TDataSource;
begin
  real := ap_data_get_struct(This);
  dlv_DataSource := ap_data_get_struct(DataSource);
  result := ap_Bool(real.IsLinkedTo( dlv_DataSource ));
end;

function DataSet_is_sequenced(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.IsSequenced);
end;

function DataSet_lookup(This, KeyFields, KeyValues, ResultFields : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_KeyFields : string;
  dlv_KeyValues : Variant;
  dlv_ResultFields : string;
begin
  real := ap_data_get_struct(This);
  dlv_KeyFields := dl_String(KeyFields);
  dlv_KeyValues := dl_Variant(KeyValues);
  dlv_ResultFields := dl_String(ResultFields);
  result := ap_Variant(real.Lookup( dlv_KeyFields, dlv_KeyValues, dlv_ResultFields ));
end;

function DataSet_translate(This, Src, Dest, ToOem : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_Src : PChar;
  dlv_Dest : PChar;
  dlv_ToOem : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_Src := ap_data_get_struct(Src);
  dlv_Dest := ap_data_get_struct(Dest);
  dlv_ToOem := dl_Boolean(ToOem);
  result := ap_Integer(real.Translate( dlv_Src, dlv_Dest, dlv_ToOem ));
end;

function DataSet_update_cursor_pos(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.UpdateCursorPos;
  result := This;
end;

function DataSet_update_record(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.UpdateRecord;
  result := This;
end;

function DataSet_update_status(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.UpdateStatus));
end;

function DataSet_get_agg_fields(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_iFields(real.AggFields,This);
end;

function DataSet_get_can_modify(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.CanModify);
end;

function DataSet_get_data_set_field(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_iField(real.DataSetField,This);
end;

function DataSet_set_data_set_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.DataSetField := ap_data_get_struct(v);
  result := v;
end;

function DataSet_get_data_source(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_iDataSource(real.DataSource,This);
end;

function DataSet_get_default_fields(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.DefaultFields);
end;

function DataSet_get_block_read_size(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.BlockReadSize);
end;

function DataSet_set_block_read_size(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.BlockReadSize := dl_Integer(v);
  result := v;
end;

function DataSet_get_field_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.FieldCount);
end;

function DataSet_get_field_defs(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_iFieldDefs(real.FieldDefs,This);
end;

function DataSet_set_field_defs(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.FieldDefs := ap_data_get_struct(v);
  result := v;
end;

function DataSet_set_field_values(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_FieldName : string;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_FieldName := dl_String(argv[0]);
  real.FieldValues[dlv_FieldName] := dl_Variant(argv[1]);
  result := argv[1];
end;

function DataSet_get_field_values(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
  dlv_FieldName : string;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_FieldName := dl_String(argv[0]);
  result := ap_Variant(real.FieldValues[dlv_FieldName]);
end;

function DataSet_get_found(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Found);
end;

function DataSet_get_is_uni_directional(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.IsUniDirectional);
end;

function DataSet_get_modified(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Modified);
end;

function DataSet_get_object_view(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.ObjectView);
end;

function DataSet_set_object_view(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.ObjectView := dl_Boolean(v);
  result := v;
end;

function DataSet_get_record_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.RecordCount);
end;

function DataSet_get_rec_no(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.RecNo);
end;

function DataSet_set_rec_no(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.RecNo := dl_Integer(v);
  result := v;
end;

function DataSet_get_record_size(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.RecordSize);
end;

function DataSet_get_sparse_arrays(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.SparseArrays);
end;

function DataSet_set_sparse_arrays(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.SparseArrays := dl_Boolean(v);
  result := v;
end;

function DataSet_get_filter(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.Filter);
end;

function DataSet_set_filter(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.Filter := dl_String(v);
  result := v;
end;

function DataSet_get_filtered(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Filtered);
end;

function DataSet_set_filtered(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.Filtered := dl_Boolean(v);
  result := v;
end;

function DataSet_get_active(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Active);
end;

function DataSet_set_active(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.Active := dl_Boolean(v);
  result := v;
end;

function DataSet_get_auto_calc_fields(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.AutoCalcFields);
end;

function DataSet_set_auto_calc_fields(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DataSet;
begin
  real := ap_data_get_struct(This);
  real.AutoCalcFields := dl_Boolean(v);
  result := v;
end;

function DataSet_get_filter_options(This: Tvalue): Tvalue; cdecl;
var
  dlv_FilterOptions: TFilterOptions;
begin
  dlv_FilterOptions := dl_DataSet(This).FilterOptions;
  result := ap_Set(dlv_FilterOptions);
end;

function DataSet_set_filter_options(This, v: Tvalue): Tvalue; cdecl;
var
  a: Integer ;
  b: TFilterOptions absolute a;
begin
  a := dl_Set(v);
  dl_DataSet(This).FilterOptions := b;
  result := v;
end;

procedure Init_DataSet;
begin
  DefineConstSetType(mRDB, TypeInfo(TDataSetState));
  DefineConstSetType(mRDB, TypeInfo(TDataAction));
  DefineConstSetType(mRDB, TypeInfo(TLocateOption));
  DefineConstSetType(mRDB, TypeInfo(TFilterOption));

  cDataSet := DefinePersistentClass(mRDB, TDataSet, ap_cComponent, nil);
  rb_define_method(cDataSet, 'event_handle', @DataSet_event_handle, 1);
  rb_undef_method(CLASS_OF(cDataSet), 'new');
  DefineAttrGet(cDataSet, 'fields', DataSet_get_fields);
  DefineAttrGet(cDataSet, 'state', DataSet_get_state);
  rb_define_method(cDataSet, 'open', @DataSet_open, 0);
  rb_define_method(cDataSet, 'close', @DataSet_close, 0);
  rb_define_method(cDataSet, 'edit', @DataSet_edit, 0);
  rb_define_method(cDataSet, 'post', @DataSet_post, 0);
  rb_define_method(cDataSet, 'append', @DataSet_append, 0);
  rb_define_method(cDataSet, 'insert', @DataSet_insert, 0);
  rb_define_method(cDataSet, 'delete', @DataSet_delete, 0);

  // vcl: FieldByName, FindField
  rb_define_method(cDataSet, '[]', @DataSet_aref, 1);
  rb_define_method(cDataSet, '[]=', @DataSet_aset, 2);

  rb_define_method(cDataSet, 'first', @DataSet_first, 0);
  rb_define_method(cDataSet, 'last', @DataSet_last, 0);
  rb_define_method(cDataSet, 'next', @DataSet_next, 0);
  rb_define_method(cDataSet, 'prior', @DataSet_prior, 0);
  rb_define_method(cDataSet, 'move_by', @DataSet_move_by, 1);
  rb_define_method(cDataSet, 'locate', @DataSet_locate, 3);
  DefineAttrGet(cDataSet, 'bof?', DataSet_get_bof);
  DefineAttrGet(cDataSet, 'eof?', DataSet_get_eof);

  rb_define_method(cDataSet, 'bookmark', @DataSet_bookmark, 0);
  rb_define_method(cDataSet, 'disable_controls', @DataSet_disable_controls, 0);
  rb_define_method(cDataSet, 'refresh', @DataSet_refresh, 0);
  rb_define_method(cDataSet, 'cancel', @DataSet_cancel, 0);
(**** str_init made by ap_src_maker ****)
  rb_define_method(cDataSet, 'bookmark_valid', @DataSet_bookmark_valid, 1);
  rb_define_method(cDataSet, 'check_browse_mode', @DataSet_check_browse_mode, 0);
  rb_define_method(cDataSet, 'clear_fields', @DataSet_clear_fields, 0);
  rb_define_method(cDataSet, 'controls_disabled', @DataSet_controls_disabled, 0);
  rb_define_method(cDataSet, 'compare_bookmarks', @DataSet_compare_bookmarks, 2);
  rb_define_method(cDataSet, 'create_blob_stream', @DataSet_create_blob_stream, 2);
  rb_define_method(cDataSet, 'cursor_pos_changed', @DataSet_cursor_pos_changed, 0);
  rb_define_method(cDataSet, 'enable_controls', @DataSet_enable_controls, 0);
  rb_define_method(cDataSet, 'field_by_name', @DataSet_field_by_name, 1);
  rb_define_method(cDataSet, 'find_field', @DataSet_find_field, 1);
  rb_define_method(cDataSet, 'find_first', @DataSet_find_first, 0);
  rb_define_method(cDataSet, 'find_last', @DataSet_find_last, 0);
  rb_define_method(cDataSet, 'find_next', @DataSet_find_next, 0);
  rb_define_method(cDataSet, 'find_prior', @DataSet_find_prior, 0);
  rb_define_method(cDataSet, 'free_bookmark', @DataSet_free_bookmark, 1);
  rb_define_method(cDataSet, 'get_current_record', @DataSet_get_current_record, 1);
  rb_define_method(cDataSet, 'get_detail_data_sets', @DataSet_get_detail_data_sets, 1);
  rb_define_method(cDataSet, 'get_detail_link_fields', @DataSet_get_detail_link_fields, 2);
  rb_define_method(cDataSet, 'get_blob_field_data', @DataSet_get_blob_field_data, 2);
  rb_define_method(cDataSet, 'get_field_data', @DataSet_get_field_data, 2);
  rb_define_method(cDataSet, 'get_field_data', @DataSet_get_field_data, 2);
  rb_define_method(cDataSet, 'get_field_data', @DataSet_get_field_data, 3);
  rb_define_method(cDataSet, 'get_field_list', @DataSet_get_field_list, 2);
  rb_define_method(cDataSet, 'get_field_names', @DataSet_get_field_names, 1);
  rb_define_method(cDataSet, 'goto_bookmark', @DataSet_goto_bookmark, 1);
  rb_define_method(cDataSet, 'is_empty', @DataSet_is_empty, 0);
  rb_define_method(cDataSet, 'is_linked_to', @DataSet_is_linked_to, 1);
  rb_define_method(cDataSet, 'is_sequenced', @DataSet_is_sequenced, 0);
  rb_define_method(cDataSet, 'lookup', @DataSet_lookup, 3);
  rb_define_method(cDataSet, 'translate', @DataSet_translate, 3);
  rb_define_method(cDataSet, 'update_cursor_pos', @DataSet_update_cursor_pos, 0);
  rb_define_method(cDataSet, 'update_record', @DataSet_update_record, 0);
  rb_define_method(cDataSet, 'update_status', @DataSet_update_status, 0);
  DefineAttrGet(cDataSet, 'agg_fields', DataSet_get_agg_fields);
  DefineAttrGet(cDataSet, 'bof', DataSet_get_bof);
  DefineAttrGet(cDataSet, 'can_modify', DataSet_get_can_modify);
  DefineAttrGet(cDataSet, 'can_modify?', DataSet_get_can_modify);
  DefineAttrGet(cDataSet, 'data_set_field', DataSet_get_data_set_field);
  DefineAttrSet(cDataSet, 'data_set_field', DataSet_set_data_set_field);
  DefineAttrGet(cDataSet, 'data_source', DataSet_get_data_source);
  DefineAttrGet(cDataSet, 'default_fields', DataSet_get_default_fields);
  DefineAttrGet(cDataSet, 'default_fields?', DataSet_get_default_fields);
  DefineAttrGet(cDataSet, 'eof', DataSet_get_eof);
  DefineAttrGet(cDataSet, 'block_read_size', DataSet_get_block_read_size);
  DefineAttrSet(cDataSet, 'block_read_size', DataSet_set_block_read_size);
  DefineAttrGet(cDataSet, 'field_count', DataSet_get_field_count);
  DefineAttrGet(cDataSet, 'field_defs', DataSet_get_field_defs);
  DefineAttrSet(cDataSet, 'field_defs', DataSet_set_field_defs);
  DefineIndexer(cDataSet, 'field_values', @DataSet_get_field_values, @DataSet_set_field_values);
  DefineAttrGet(cDataSet, 'found', DataSet_get_found);
  DefineAttrGet(cDataSet, 'found?', DataSet_get_found);
  DefineAttrGet(cDataSet, 'is_uni_directional', DataSet_get_is_uni_directional);
  DefineAttrGet(cDataSet, 'is_uni_directional?', DataSet_get_is_uni_directional);
  DefineAttrGet(cDataSet, 'modified', DataSet_get_modified);
  DefineAttrGet(cDataSet, 'modified?', DataSet_get_modified);
  DefineAttrGet(cDataSet, 'object_view', DataSet_get_object_view);
  DefineAttrGet(cDataSet, 'object_view?', DataSet_get_object_view);
  DefineAttrSet(cDataSet, 'object_view', DataSet_set_object_view);
  DefineAttrGet(cDataSet, 'record_count', DataSet_get_record_count);
  DefineAttrGet(cDataSet, 'rec_no', DataSet_get_rec_no);
  DefineAttrSet(cDataSet, 'rec_no', DataSet_set_rec_no);
  DefineAttrGet(cDataSet, 'record_size', DataSet_get_record_size);
  DefineAttrGet(cDataSet, 'sparse_arrays', DataSet_get_sparse_arrays);
  DefineAttrGet(cDataSet, 'sparse_arrays?', DataSet_get_sparse_arrays);
  DefineAttrSet(cDataSet, 'sparse_arrays', DataSet_set_sparse_arrays);
  DefineAttrGet(cDataSet, 'filter', DataSet_get_filter);
  DefineAttrSet(cDataSet, 'filter', DataSet_set_filter);
  DefineAttrGet(cDataSet, 'filtered', DataSet_get_filtered);
  DefineAttrGet(cDataSet, 'filtered?', DataSet_get_filtered);
  DefineAttrSet(cDataSet, 'filtered', DataSet_set_filtered);
  DefineAttrGet(cDataSet, 'active', DataSet_get_active);
  DefineAttrGet(cDataSet, 'active?', DataSet_get_active);
  DefineAttrSet(cDataSet, 'active', DataSet_set_active);
  DefineAttrGet(cDataSet, 'auto_calc_fields', DataSet_get_auto_calc_fields);
  DefineAttrGet(cDataSet, 'auto_calc_fields?', DataSet_get_auto_calc_fields);
  DefineAttrSet(cDataSet, 'auto_calc_fields', DataSet_set_auto_calc_fields);
(**** made by ap_src_maker ****)
  DefineAttrGet(cDataSet, 'filter_options', DataSet_get_filter_options);
  DefineAttrSet(cDataSet, 'filter_options', DataSet_set_filter_options);
end;

exports
  ap_cDataSet,
  DataSet_setup,
  DataSet_alloc,
  RDBDataSetTmpAllocFuncList;

initialization
  FDataSetTmpAllocFuncList := TList.Create;

finalization
  FDataSetTmpAllocFuncList.Free;

end.
