unit uModule;

interface

uses Classes, WebBroker, HTTPApp, Rubies;

var
  cWebModule: Tvalue;
  vWebModule: Tvalue;

function ap_cWebModule: Tvalue;
function ap_iWebModule(real: TWebModule; owner: Tvalue): Tvalue;
function Regist_WebModule(real: TWebModule; owner: Tvalue): Tvalue;
function WebModule_get_request(This: Tvalue): Tvalue; cdecl;
function WebModule_get_response(This: Tvalue): Tvalue; cdecl;
procedure Init_WebModule;

implementation

uses
  SysUtils, uDefUtils, Pythia, uWeb, WebHandle, uRequest, uResponse;

function ap_cWebModule: Tvalue;
begin
  result := cWebModule;
end;

procedure WebModule_setup(obj: Tvalue; real: TWebModule);
begin
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
  if @real.BeforeDispatch = nil then
      real.BeforeDispatch := Handle.HTTPMethodBeforeDispatch;
  if @real.AfterDispatch = nil then
      real.AfterDispatch := Handle.HTTPMethodAfterDispatch;
end;

function WebModule_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function WebModule_alloc(This: Tvalue; real: TWebModule): Tvalue;
begin
  result := ChildAlloc(This, real);
  WebModule_setup(result, real);
end;

function ap_iWebModule(real: TWebModule; owner: Tvalue): Tvalue;
begin
  result := WebModule_alloc(cWebModule, real);
  ap_owner(result, owner);
end;

function ap_iWebModule_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iWebModule(TWebModule(AControl), owner)
end;

function Regist_WebModule(real: TWebModule; owner: Tvalue): Tvalue;
begin
  result := ap_iWebModule(real, owner);
  vWebModule := result;
  rb_define_const(mWeb, 'MODULE', result);
  WebModule_setup(result, real);
end;

procedure WebRequest_reset(obj: Tvalue; real: TWebRequest);
begin
  PRData(rb_iv_get(obj, '@content_fields'))^.data := real.ContentFields;
  PRData(rb_iv_get(obj, '@cookie_fields'))^.data := real.CookieFields;
  PRData(rb_iv_get(obj, '@query_fields'))^.data := real.QueryFields;
end;

function WebModule_get_request(This: Tvalue): Tvalue; cdecl;
var
  real: TWebModule;
  item: TWebRequest;
begin
  real := ap_data_get_struct(This);
  result := rb_iv_get(This, '@request');
  item := real.Request;
  if result = Qnil then begin
    result := ap_iRequest(item, This);
    rb_iv_set(This, '@request', result);
  end else begin
    Check_Type(result, T_DATA);
    PRData(result)^.data := item;
    WebRequest_reset(result, item);
  end;
end;

function WebModule_get_response(This: Tvalue): Tvalue; cdecl;
var
  real: TWebModule;
  item: TWebResponse;
begin
  real := ap_data_get_struct(This);
  result := rb_iv_get(This, '@response');
  item := real.Response;
  if result = Qnil then begin
    result := ap_iResponse(item, This);
    rb_iv_set(This, '@response', result);
  end else begin
    Check_Type(result, T_DATA);
    PRData(result)^.data := item;
  end;
end;

procedure Init_WebModule;
begin
  cWebModule := rb_define_class_under(mWeb, 'Module', ap_cComponent);
  DefineProp(cWebModule, TWebModule);
  rb_define_method(cWebModule, 'event_handle', @WebModule_event_handle, 1);
  DefineAttrGet(cWebModule, 'request', WebModule_get_request);
  DefineAttrGet(cWebModule, 'response', WebModule_get_response);
end;

exports
  Regist_WebModule;

end.
