require "test/unit"
require "phi"
class TCEdit < Test::Unit::TestCase
  def test_ancestors
    assert_equal Phi::WinControl, Phi::Edit.superclass
  end

  def setup
    @form = Phi::Form.new(:form)
  end

  def test_tag
    instance = Phi::Edit.new(@form, :edit)
    assert_raise(NoMethodError) { instance.tag }
  end

  def test_new_name_default
    instance = Phi::Edit.new(@form)
    assert_equal 'Edit1', instance.name
    assert_equal instance, @form.instance_eval { @Edit1 }
    assert_equal instance, @form.instance_eval { self.Edit1 }
  end

  def test_new_name
    instance = Phi::Edit.new(@form, :edit)
    assert_equal 'edit', instance.name
    assert_equal instance, @form.instance_eval { @edit }
    assert_equal instance, @form.instance_eval { self.edit }
  end

  def test_new_text_default
    instance = Phi::Edit.new(@form, :edit)
    assert_equal '', instance.text
  end

  def test_new_text
    instance = Phi::Edit.new(@form, :edit, 'hello')
    assert_equal 'hello', instance.text
  end
end
