unit uActionManager;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  ActnMan,
  Rubies;


var
  cActionManager: Tvalue;

function ap_cActionManager: Tvalue;
function ap_iActionManager(real: TActionManager; owner: Tvalue): Tvalue;
procedure Init_ActionManager;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cActionManager: Tvalue;
begin
  result := cActionManager;
end;

procedure ActionManager_setup(obj: Tvalue; real: TActionManager);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ActionManager_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ActionManager_alloc(This: Tvalue; real: TActionManager): Tvalue;
begin
  result := ChildAlloc(This, real);
  ActionManager_setup(result, real);
end;

function ap_iActionManager(real: TActionManager; owner: Tvalue): Tvalue;
begin
  result := ActionManager_alloc(cActionManager, real);
  ap_owner(result, owner);
end;

function ap_iActionManager_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iActionManager(TActionManager(AControl), owner);
end;

function ActionManager_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TActionManager;
begin
  real := TActionManager.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ActionManager_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_ActionManager = class(TActionManager)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function ActionManager_load_from_file(This, Filename : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionManager;
  dlv_Filename : string;
begin
  real := ap_data_get_struct(This);
  dlv_Filename := dl_String(Filename);
  real.LoadFromFile( dlv_Filename );
  result := This;
end;

function ActionManager_load_from_stream(This, S : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionManager;
  dlv_S : TStream;
begin
  real := ap_data_get_struct(This);
  dlv_S := ap_data_get_struct(S);
  real.LoadFromStream( dlv_S );
  result := This;
end;

function ActionManager_reset_action_bar(This, Index : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionManager;
  dlv_Index : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(Index);
  real.ResetActionBar( dlv_Index );
  result := This;
end;

function ActionManager_reset_usage_data(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionManager;
begin
  real := ap_data_get_struct(This);
  real.ResetUsageData;
  result := This;
end;

function ActionManager_save_to_file(This, Filename : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionManager;
  dlv_Filename : string;
begin
  real := ap_data_get_struct(This);
  dlv_Filename := dl_String(Filename);
  real.SaveToFile( dlv_Filename );
  result := This;
end;

function ActionManager_save_to_stream(This, S : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ActionManager;
  dlv_S : TStream;
begin
  real := ap_data_get_struct(This);
  dlv_S := ap_data_get_struct(S);
  real.SaveToStream( dlv_S );
  result := This;
end;

(**** made by ap_src_maker ****)

procedure Init_ActionManager;
begin
  cActionManager := OutputPersistentClass(mPhi, TActionManager, cWinControl, ap_iActionManager_v);
  rb_define_method(cActionManager, 'event_handle', @ActionManager_event_handle, 1);
  DefineSingletonMethod(cActionManager, 'new', ActionManager_new);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cActionManager, 'load_from_file', @ActionManager_load_from_file, 1);
  rb_define_method(cActionManager, 'load_from_stream', @ActionManager_load_from_stream, 1);
  rb_define_method(cActionManager, 'reset_action_bar', @ActionManager_reset_action_bar, 1);
  rb_define_method(cActionManager, 'reset_usage_data', @ActionManager_reset_usage_data, 0);
  rb_define_method(cActionManager, 'save_to_file', @ActionManager_save_to_file, 1);
  rb_define_method(cActionManager, 'save_to_stream', @ActionManager_save_to_stream, 1);
//  DefineAttrGet(cActionManager, 'action_bars', ActionManager_get_action_bars);
//  DefineAttrSet(cActionManager, 'action_bars', ActionManager_set_action_bars);
//  DefineAttrGet(cActionManager, 'default_action_bars', ActionManager_get_default_action_bars);
//  DefineAttrGet(cActionManager, 'linked_action_lists', ActionManager_get_linked_action_lists);
//  DefineAttrGet(cActionManager, 'file_name', ActionManager_get_file_name);
//  DefineAttrSet(cActionManager, 'file_name', ActionManager_set_file_name);
//  DefineAttrGet(cActionManager, 'priority_schedule', ActionManager_get_priority_schedule);
(**** made by ap_src_maker ****)

end;

end.
