unit uActionToolBar;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  ActnCtrls,
  Rubies;

var
  cActionToolBar: Tvalue;

function ap_cActionToolBar: Tvalue;
function ap_iActionToolBar(real: TActionToolBar; owner: Tvalue): Tvalue;
procedure Init_ActionToolBar;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cActionToolBar: Tvalue;
begin
  result := cActionToolBar;
end;

procedure ActionToolBar_setup(obj: Tvalue; real: TActionToolBar);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ActionToolBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ActionToolBar_alloc(This: Tvalue; real: TActionToolBar): Tvalue;
begin
  result := ChildAlloc(This, real);
  ActionToolBar_setup(result, real);
end;

function ap_iActionToolBar(real: TActionToolBar; owner: Tvalue): Tvalue;
begin
  result := ActionToolBar_alloc(cActionToolBar, real);
  ap_owner(result, owner);
end;

function ap_iActionToolBar_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iActionToolBar(TActionToolBar(AControl), owner);
end;

function ActionToolBar_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TActionToolBar;
begin
  real := TActionToolBar.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  ActionToolBar_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

(**** str_method made by ap_src_maker ****)

function ActionToolBar_drag_drop(This, Source, X, Y : Tvalue): Tvalue; cdecl;
var
  real: TActionToolBar;
  dlv_Source : TObject;
  dlv_X : Integer;
  dlv_Y : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_Source := ap_data_get_struct(Source);
  dlv_X := dl_Integer(X);
  dlv_Y := dl_Integer(Y);
  real.DragDrop( dlv_Source, dlv_X, dlv_Y );
  result := This;
end;

function ActionToolBar_get_hidden_count(This: Tvalue): Tvalue; cdecl;
var
  real: TActionToolBar;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.HiddenCount);  
end;
(**** made by ap_src_maker ****)

procedure Init_ActionToolBar;
begin
  cActionToolBar := OutputPersistentClass(mPhi, TActionToolBar, cWinControl, ap_iActionToolBar_v);
  rb_define_method(cActionToolBar, 'event_handle', @ActionToolBar_event_handle, 1);
  DefineSingletonMethod(cActionToolBar, 'new', ActionToolBar_new);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cActionToolBar, 'drag_drop', @ActionToolBar_drag_drop, 3);
  DefineAttrGet(cActionToolBar, 'hidden_count', ActionToolBar_get_hidden_count);
(**** made by ap_src_maker ****)

end;

end.
