unit uControl;

interface

uses
{$IFDEF VCL}
  Controls,
{$ELSE}
  QControls,
{$ENDIF}
  Rubies;

var
  cControl, cWinControl: Tvalue;

procedure ClearEvents(AControl: TControl);
function ap_cControl: Tvalue;
function ap_cWinControl: Tvalue;
procedure Init_control;

implementation

uses
  classes,
{$IFDEF LINUX}
  Types,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  TypInfo,
{$IFDEF VCL}
  ActnList,
{$ELSE}
  QActnList,
{$ENDIF}
  uAction,
  uDefUtils, uIntern, uProp, uPhi, uConv, uPoint, uRect, uPersistent, uComponent;

type
  TMyWinControl = class(TWinControl);

function ap_Control(v:TControl):TValue;
begin
  result := v.tag;
end;

function ap_WinControl(v:TWinControl):TValue;
begin
  result := v.tag;
end;

procedure ClearEvents(AControl: TControl);
var
  i: Integer;
  real: TWinControl;
  obj, events: Tvalue;
begin
  if not (AControl is TWinControl) then Exit;
  real := TWinControl(AControl);
  for i := 0 to real.ControlCount-1 do
    ClearEvents(real.Controls[i]);
  obj := real.tag;
  if obj = 0 then Exit; // undefined
  events := rb_iv_get(obj, '@events');
  if events <> Qnil then
    rb_funcall2(events, id_clear, 0, nil);
end;

function ap_cControl: Tvalue;
begin
  result := cControl;
end;

function ap_cWinControl: Tvalue;
begin
  result := cWinControl;
end;

function Control_show(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
asm
  FInit;
end;
  real.Show;
  result := This;
end;

function Control_hide(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.Hide;
  result := This;
end;

function Control_bring_to_front(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.BringToFront;
  result := This;
end;

function Control_send_to_back(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.SendToBack;
  result := This;
end;

function Control_screen_to_client(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  point: TPoint;
begin
  real := ap_data_get_struct(This);
  point := real.ScreenToClient(TPoint(ap_data_get_struct(v)^));
  result := ap_iPoint(point, Qnil);
end;

function Control_set_bounds(This, left, top, width, height: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.SetBounds(FIX2INT(left), FIX2INT(top), FIX2INT(width), FIX2INT(height));
  result := This;
end;

function Control_client_to_screen(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  point: TPoint;
begin
  real := ap_data_get_struct(This);
  point := real.ClientToScreen(TPoint(ap_data_get_struct(v)^));
  result := ap_iPoint(point, Qnil);
end;

function Control_set_rect(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.BoundsRect := PRect(ap_data_get_struct(v))^;
  result := v;
end;

function Control_get_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := ap_iRect(real.BoundsRect, This);
end;

function Control_set_align(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.Align := TAlign(FIX2INT(v));
  result := v;
end;

function Control_get_align(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(Ord(real.Align));
end;

function Control_set_parent(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  parent: Tvalue;
  my_name: string;
  control: TWinControl;
begin
  real := ap_data_get_struct(This);
  parent := rb_iv_get(This, '@parent');
  if parent <> Qnil then
  begin
    my_name := '@'+real.name;
    rb_iv_set(parent, PChar(my_name), Qnil);
  end;
  ap_data_get_object(v, TWinControl, control);
  real.parent := TWinControl(control);
  rb_iv_set(This, '@parent', v);
  result := v;
end;

function Control_begin_drag(argc: integer; args: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  Immediate: Boolean;
  Threshold: Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  if argc > 1 then
    Threshold := FIX2INT(args[1])
  else
    Threshold := -1
  ;
  real := ap_data_get_struct(This);
  Immediate := RTEST(args[0]);
  real.BeginDrag(Immediate, Threshold);
  result := This;
end;

{$IFDEF VCL}
function Control_perform(This, msg, wparam, lparam: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.Perform(
    dl_Integer(msg),
    dl_Integer(wparam),
    dl_Integer(lparam)));
end;
{$ENDIF}

function Control_focused_p(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.focused);
end;

function Control_set_focus(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.SetFocus;
  result := This;
end;

function Control_scale_by(This, m, d: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.ScaleBy(FIX2INT(m), FIX2INT(d));
  result := This;
end;

function Control_invalidate(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.invalidate;
  result := This;
end;

function Control_update(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.update;
  result := This;
end;

function Control_repaint(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.repaint;
  result := This;
end;

function Control_refresh(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  real.refresh;
  result := This;
end;

function Control_get_handle(This: Tvalue): Tvalue; cdecl;
{$IFDEF VCL}
var
  real: TWinControl;
{$ENDIF}
begin
{$IFDEF VCL}
  real := ap_data_get_struct(This);
  result := ap_Handle(real.Handle);
{$ELSE}
  result := Qnil;
{$ENDIF}
end;

function Control_set_control_state(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  i: Integer;
  State: TControlState absolute i;
begin
  real := ap_data_get_struct(This);
  i := dl_Set(v);
  real.ControlState := State;
  result := v;
end;

function Control_get_control_state(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  state: TControlState;
begin
  real := ap_data_get_struct(This);
  state := real.ControlState;
  result := ap_Set(state);
end;

function Control_set_control_style(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  i: Integer;
  Style: TControlStyle absolute i;
begin
  real := ap_data_get_struct(This);
  i := dl_Set(v);
  real.ControlStyle := Style;
  result := v;
end;

function Control_get_control_style(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
  style: TControlStyle;
begin
  real := ap_data_get_struct(This);
  style := real.ControlStyle;
  result := ap_Set(style);
end;

function Control_get_controls(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
  i: Integer;
  args: array of Tvalue;
  obj, control_class, kind_p, push_p: Tvalue;
begin
  SetLength(args, argc);
  args := argv;

  if argc > 0 then
    control_class := args[0]
  else
    control_class := Qnil;

  if argc > 1 then
    kind_p := args[1]
  else
    kind_p := Qnil;

  real := ap_data_get_struct(This);

  if rb_block_given_p <> 0 then
    result := Qnil
  else
    result := rb_ary_new;

  for i := 0 to real.ControlCount-1 do
  begin
    obj := real.Controls[i].tag;
    if obj = 0 then Continue;
    if control_class = Qnil then
      push_p := Qtrue
    else
      if RTEST(kind_p) then
        push_p := rb_obj_is_kind_of(obj, control_class)
      else
        push_p := rb_obj_is_instance_of(obj, control_class);

    if RTEST(push_p) then
      if rb_block_given_p <> 0 then
        rb_yield(obj)
      else
        rb_ary_push(result, obj);

  end;
end;

function Control_get_control_count(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ControlCount);
end;

function Control_stop_align(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  try
    real.DisableAlign;
    result := rb_yield(Qnil);
  finally
    real.EnableAlign;
  end;
end;

function Control_handle_needed(This: TValue): TValue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.HandleNeeded;
  Result := This;
end;

function Control_control_at_pos(This, v: TValue): TValue; cdecl;
var
  real: TWinControl;
  AControl: TControl;
begin
  real := ap_data_get_struct(This);
  AControl := real.ControlAtPos(TPoint(ap_data_get_struct(v)^), True, True);
  if AControl = nil then
    Result := Qnil
  else
    Result := AControl.tag;
end;

function Control_select_first(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.SelectFirst;
  Result := This;
end;

function Control_select_next(This, cur, forward, tab_stop: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  CurControl: TWinControl;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(cur, TWinControl, CurControl);
  real.SelectNext(CurControl, RTEST(forward), RTEST(tab_stop));
  Result := This;
end;

function Control_showing_p(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Showing);
end;

{$IFDEF VCL}
function Control_set_double_buffered(This, v: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  real.DoubleBuffered := RTEST(v);
  result := This;
end;

function Control_get_double_buffered(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.DoubleBuffered);
end;
{$ENDIF}

function Control_client_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_iRect(real.ClientRect, This);
end;

function Control_adjusted_client_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  rect:TRect;
begin
  real := ap_data_get_struct(This);
  rect := real.ClientRect;
  real.AdjustClientRect(rect);
  result := ap_iRect(rect, This);
end;

function Control_set_action(This, v: Tvalue): Tvalue; cdecl;
var
  real: TControl;
//  action: TAction;
begin
  real := ap_data_get_struct(This);
  real.action := ap_data_get_struct(v);
  result := This;
end;

function Control_get_action(This: Tvalue): Tvalue; cdecl;
var
  real: TControl;
begin
  real := ap_data_get_struct(This);
  result := ap_iBasicAction(real.Action,This);
end;

(**** str2 made by ap_src_maker ****)

function WinControl_can_focus(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.CanFocus);
end;

function WinControl_contains_control(This, Control : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Control : TControl;
begin
  real := ap_data_get_struct(This);
  dl_Control := ap_data_get_struct(Control);
  result := ap_Bool(real.ContainsControl( dl_Control ));
end;

function WinControl_disable_align(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.DisableAlign;
  result := This;
end;
{$IFDEF VCL}
function WinControl_get_dock_client_count(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.DockClientCount);
end;

function WinControl_get_dock_clients(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dl_Index := dl_Integer(argv[0]);
  result := ap_Control(real.DockClients[dl_Index]);
end;

function WinControl_dock_drop(This, Source, X, Y : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Source : TDragDockObject;
  dl_X : Integer;
  dl_Y : Integer;
begin
  real := ap_data_get_struct(This);
  dl_Source := ap_data_get_struct(Source);
  dl_X := dl_Integer(X);
  dl_Y := dl_Integer(Y);
  real.DockDrop( dl_Source, dl_X, dl_Y );
  result := This;
end;
{$ENDIF}
function WinControl_enable_align(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.EnableAlign;
  result := This;
end;

function WinControl_find_child_control(This, ControlName : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_ControlName : string;
begin
  real := ap_data_get_struct(This);
  dl_ControlName := dl_String(ControlName);
  result := ap_Control(real.FindChildControl( dl_ControlName ));
end;

function WinControl_flip_children(This, AllLevels : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_AllLevels : Boolean;
begin
  real := ap_data_get_struct(This);
  dl_AllLevels := dl_Boolean(AllLevels);
  real.FlipChildren( dl_AllLevels );
  result := This;
end;

function WinControl_focused(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Focused);
end;

function WinControl_get_tab_order_list(This, List : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_List : TList;
begin
  real := ap_data_get_struct(This);
  dl_List := ap_data_get_struct(List);
  real.GetTabOrderList( dl_List );
  result := This;
end;

function WinControl_handle_allocated(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.HandleAllocated);
end;

function WinControl_insert_control(This, AControl : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_AControl : TControl;
begin
  real := ap_data_get_struct(This);
  dl_AControl := ap_data_get_struct(AControl);
  real.InsertControl( dl_AControl );
  result := This;
end;

function WinControl_remove_control(This, AControl : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_AControl : TControl;
begin
  real := ap_data_get_struct(This);
  dl_AControl := ap_data_get_struct(AControl);
  real.RemoveControl( dl_AControl );
  result := This;
end;

function WinControl_realign(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.Realign;
  result := This;
end;

function WinControl_scroll_by(This, DeltaX, DeltaY : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_DeltaX : Integer;
  dl_DeltaY : Integer;
begin
  real := ap_data_get_struct(This);
  dl_DeltaX := dl_Integer(DeltaX);
  dl_DeltaY := dl_Integer(DeltaY);
  real.ScrollBy( dl_DeltaX, dl_DeltaY );
  result := This;
end;

function WinControl_update_control_state(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.UpdateControlState;
  result := This;
end;
{$IFDEF VCL}
function WinControl_get_align_disabled(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.AlignDisabled);
end;

function WinControl_get_visible_dock_client_count(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.VisibleDockClientCount);
end;

function WinControl_get_parent_window(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Handle(ord(real.ParentWindow));
end;

function WinControl_set_parent_window(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.ParentWindow := HWND(dl_Handle(v));
  result := v;
end;
{$ENDIF}
function WinControl_get_showing(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Showing);
end;

function WinControl_get_tab_stop(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.TabStop);
end;

function WinControl_set_tab_stop(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.TabStop := dl_Boolean(v);
  result := v;
end;

function WinControl_action_change(This, Sender, CheckDefaults : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Sender : TObject;
  dl_CheckDefaults : Boolean;
begin
  real := ap_data_get_struct(This);
  dl_Sender := ap_data_get_struct(Sender);
  dl_CheckDefaults := dl_Boolean(CheckDefaults);
  real.ActionChange( dl_Sender, dl_CheckDefaults );
  result := This;
end;

function WinControl_assign_to(This, Dest : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Dest : TPersistent;
begin
  real := ap_data_get_struct(This);
  dl_Dest := ap_data_get_struct(Dest);
  real.AssignTo( dl_Dest );
  result := This;
end;

function WinControl_adjust_client_rect(This, Rect : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Rect0 : TRect;
begin
  real := ap_data_get_struct(This);
  dl_Rect0 := dl_Rect(Rect);
  real.AdjustClientRect( dl_Rect0 );
  result := This;
end;

function WinControl_adjust_size(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.AdjustSize;
  result := This;
end;

function WinControl_align_controls(This, AControl, Rect : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_AControl : TControl;
  dl_Rect0 : TRect;
begin
  real := ap_data_get_struct(This);
  dl_AControl := ap_data_get_struct(AControl);
  dl_Rect0 := dl_Rect(Rect);
  real.AlignControls( dl_AControl, dl_Rect0 );
  result := This;
end;
{$IFDEF VCL}
function WinControl_can_auto_size(This, NewWidth, NewHeight : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_NewWidth : Integer;
  dl_NewHeight : Integer;
begin
  real := ap_data_get_struct(This);
  dl_NewWidth := dl_Integer(NewWidth);
  dl_NewHeight := dl_Integer(NewHeight);
  result := ap_Bool(real.CanAutoSize( dl_NewWidth, dl_NewHeight ));
end;

function WinControl_can_resize(This, NewWidth, NewHeight : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_NewWidth : Integer;
  dl_NewHeight : Integer;
begin
  real := ap_data_get_struct(This);
  dl_NewWidth := dl_Integer(NewWidth);
  dl_NewHeight := dl_Integer(NewHeight);
  result := ap_Bool(real.CanResize( dl_NewWidth, dl_NewHeight ));
end;
{$ENDIF}
function WinControl_change_scale(This, M, D : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_M : Integer;
  dl_D : Integer;
begin
  real := ap_data_get_struct(This);
  dl_M := dl_Integer(M);
  dl_D := dl_Integer(D);
{$IFDEF VCL}
  real.ChangeScale( dl_M, dl_D );
{$ELSE}
  real.ChangeScale( dl_M, dl_D, dl_M, dl_D );
{$ENDIF}
  result := This;
end;

function WinControl_constrained_resize(This, MinWidth, MinHeight, MaxWidth, MaxHeight : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_MinWidth : Integer;
  dl_MinHeight : Integer;
  dl_MaxWidth : Integer;
  dl_MaxHeight : Integer;
begin
  real := ap_data_get_struct(This);
  dl_MinWidth := dl_Integer(MinWidth);
  dl_MinHeight := dl_Integer(MinHeight);
  dl_MaxWidth := dl_Integer(MaxWidth);
  dl_MaxHeight := dl_Integer(MaxHeight);
  real.ConstrainedResize( dl_MinWidth, dl_MinHeight, dl_MaxWidth, dl_MaxHeight );
  result := This;
end;

function WinControl_controls_aligned(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.ControlsAligned;
  result := This;
end;

function WinControl_create_handle(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.CreateHandle;
  result := This;
end;
{$IFDEF VCL}
function WinControl_create_wnd(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.CreateWnd;
  result := This;
end;
{$ENDIF}
function WinControl_custom_align_insert_before(This, C1, C2 : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_C1 : TControl;
  dl_C2 : TControl;
begin
  real := ap_data_get_struct(This);
  dl_C1 := ap_data_get_struct(C1);
  dl_C2 := ap_data_get_struct(C2);
  result := ap_Bool(real.CustomAlignInsertBefore( dl_C1, dl_C2 ));
end;

function WinControl_define_properties(This, Filer : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Filer : TFiler;
begin
  real := ap_data_get_struct(This);
  dl_Filer := ap_data_get_struct(Filer);
  real.DefineProperties( dl_Filer );
  result := This;
end;

function WinControl_destroy_handle(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.DestroyHandle;
  result := This;
end;
{$IFDEF VCL}
function WinControl_destroy_window_handle(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.DestroyWindowHandle;
  result := This;
end;

function WinControl_destroy_wnd(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.DestroyWnd;
  result := This;
end;
{$ENDIF}
function WinControl_find_next_control(This, CurControl, GoForward, CheckTabStop, CheckParent : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_CurControl : TWinControl;
  dl_GoForward : Boolean;
  dl_CheckTabStop : Boolean;
  dl_CheckParent : Boolean;
begin
  real := ap_data_get_struct(This);
  dl_CurControl := ap_data_get_struct(CurControl);
  dl_GoForward := dl_Boolean(GoForward);
  dl_CheckTabStop := dl_Boolean(CheckTabStop);
  dl_CheckParent := dl_Boolean(CheckParent);
  result := ap_WinControl(real.FindNextControl( dl_CurControl, dl_GoForward, dl_CheckTabStop, dl_CheckParent ));
end;

function WinControl_fixup_tab_list(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.FixupTabList;
  result := This;
end;

function WinControl_get_client_origin(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_iPoint(real.GetClientOrigin,This);
end;

function WinControl_get_client_rect(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_iRect(real.GetClientRect,This);
end;
{$IFDEF VCL}
function WinControl_get_control_extents(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_iRect(real.GetControlExtents,This);
end;

function WinControl_get_device_context(This, WindowHandle : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_WindowHandle : HWnd;
begin
  real := ap_data_get_struct(This);
  dl_WindowHandle := HWND(dl_Handle(WindowHandle));
  result := ap_Handle(ord(real.GetDeviceContext( dl_WindowHandle )));
end;

function WinControl_get_parent_handle(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Handle(ord(real.GetParentHandle));
end;

function WinControl_get_site_info(This, Client, InfluenceRect, MousePos, CanDock : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Client : TControl;
  dl_InfluenceRect : TRect;
  dl_MousePos : TPoint;
  dl_CanDock : Boolean;
begin
  real := ap_data_get_struct(This);
  dl_Client := ap_data_get_struct(Client);
  dl_InfluenceRect := dl_Rect(InfluenceRect);
  dl_MousePos := dl_Point(MousePos);
  dl_CanDock := dl_Boolean(CanDock);
  real.GetSiteInfo( dl_Client, dl_InfluenceRect, dl_MousePos, dl_CanDock );
  result := This;
end;

function WinControl_get_top_parent_handle(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Handle(ord(real.GetTopParentHandle));
end;
{$ENDIF}
function WinControl_key_press(This, Key : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Key : Char;
begin
  real := ap_data_get_struct(This);
  dl_Key := char(dl_Integer(Key));
  real.KeyPress( dl_Key );
  result := This;
end;
{$IFDEF VCL}
function WinControl_paint_controls(This, DC, First : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_DC : HDC;
  dl_First : TControl;
begin
  real := ap_data_get_struct(This);
  dl_DC := HDC(dl_Handle(DC));
  dl_First := ap_data_get_struct(First);
  real.PaintControls( dl_DC, dl_First );
  result := This;
end;

function WinControl_paint_window(This, DC : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_DC : HDC;
begin
  real := ap_data_get_struct(This);
  dl_DC := HDC(dl_Handle(DC));
  real.PaintWindow( dl_DC );
  result := This;
end;
{$ENDIF}
{$IFDEF VCL}
function WinControl_palette_changed(This, Foreground : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Foreground : Boolean;
begin
  real := ap_data_get_struct(This);
  dl_Foreground := dl_Boolean(Foreground);
  result := ap_Bool(real.PaletteChanged( dl_Foreground ));
end;
{$ENDIF}
function WinControl_read_state(This, Reader : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Reader : TReader;
begin
  real := ap_data_get_struct(This);
  dl_Reader := ap_data_get_struct(Reader);
  real.ReadState( dl_Reader );
  result := This;
end;
{$IFDEF VCL}
function WinControl_recreate_wnd(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.RecreateWnd;
  result := This;
end;

function WinControl_reload_docked_control(This, AControlName, AControl : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_AControlName : string;
  dl_AControl : TControl;
begin
  real := ap_data_get_struct(This);
  dl_AControlName := dl_String(AControlName);
  dl_AControl := ap_data_get_struct(AControl);
  real.ReloadDockedControl( dl_AControlName, dl_AControl );
  result := This;
end;

function WinControl_reset_ime(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.ResetIme;
  result := This;
end;
{$ENDIF}
function WinControl_scale_controls(This, M, D : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_M : Integer;
  dl_D : Integer;
begin
  real := ap_data_get_struct(This);
  dl_M := dl_Integer(M);
  dl_D := dl_Integer(D);
  real.ScaleControls( dl_M, dl_D );
  result := This;
end;

function WinControl_set_child_order(This, Child, Order : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_Child : TComponent;
  dl_Order : Integer;
begin
  real := ap_data_get_struct(This);
  dl_Child := ap_data_get_struct(Child);
  dl_Order := dl_Integer(Order);
  real.SetChildOrder( dl_Child, dl_Order );
  result := This;
end;
{$IFDEF VCL}
function WinControl_set_ime(This : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.SetIme;
  result := This;
end;
{$ENDIF}
function WinControl_set_z_order(This, TopMost : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_TopMost : Boolean;
begin
  real := ap_data_get_struct(This);
  dl_TopMost := dl_Boolean(TopMost);
  real.SetZOrder( dl_TopMost );
  result := This;
end;

function WinControl_show_control(This, AControl : Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
  dl_AControl : TControl;
begin
  real := ap_data_get_struct(This);
  dl_AControl := ap_data_get_struct(AControl);
  real.ShowControl( dl_AControl );
  result := This;
end;
{$IFDEF VCL}
function WinControl_get_ctl3d(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.Ctl3D);
end;

function WinControl_set_ctl3d(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.Ctl3D := dl_Boolean(v);
  result := v;
end;

function WinControl_set_def_wnd_proc(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.DefWndProc := ap_data_get_struct(v);
  result := v;
end;

function WinControl_get_dock_site(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.DockSite);
end;

function WinControl_set_dock_site(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.DockSite := dl_Boolean(v);
  result := v;
end;

function WinControl_get_parent_ctl3d(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.ParentCtl3D);
end;

function WinControl_set_parent_ctl3d(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.ParentCtl3D := dl_Boolean(v);
  result := v;
end;

function WinControl_get_use_dock_manager(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.UseDockManager);
end;

function WinControl_set_use_dock_manager(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.UseDockManager := dl_Boolean(v);
  result := v;
end;

function WinControl_get_window_handle(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Handle(ord(real.WindowHandle));
end;

function WinControl_set_window_handle(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.WindowHandle := HWND(dl_Handle(v));
  result := v;
end;
{$ENDIF}

(**** made by ap_src_maker ****)

{$IFDEF VCL}
function WinControl_get_bevel_width(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.BevelWidth));
end;

function WinControl_set_bevel_width(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.BevelWidth := TBevelWidth(dl_Integer(v));
  result := v;
end;

function WinControl_get_border_width(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.BorderWidth));
end;

function WinControl_set_border_width(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.BorderWidth := TBorderWidth(dl_Integer(v));
  result := v;
end;

function WinControl_get_ime_mode(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.ImeMode));
end;

function WinControl_set_ime_mode(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.ImeMode := TImeMode(dl_Integer(v));
  result := v;
end;

function WinControl_get_ime_name(This: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  result := ap_String(real.ImeName);
end;

function WinControl_set_ime_name(This, v: Tvalue): Tvalue; cdecl;
var
  real: TMyWinControl;
begin
  real := ap_data_get_struct(This);
  real.ImeName := dl_String(v);
  result := v;
end;
{$ENDIF}

(**** made by ap_src_maker ****)

procedure Init_Control;
begin
//  OutputConstSetType(mPhi, TypeInfo(TControlState));
//  OutputConstSetType(mPhi, TypeInfo(TControlStyle));

  cControl := OutputPersistentClass(mPhi, TControl, cComponent, nil);
  { methods }
  rb_define_method(cControl, 'show', @Control_show, 0);
  rb_define_method(cControl, 'hide', @Control_hide, 0);
  rb_define_method(cControl, 'bring_to_front', @Control_bring_to_front, 0);
  rb_define_method(cControl, 'send_to_back', @Control_send_to_back, 0);
  rb_define_method(cControl, 'screen_to_client', @Control_screen_to_client, 1);
  rb_define_method(cControl, 'client_to_screen', @Control_client_to_screen, 1);
  rb_define_method(cControl, 'set_bounds', @Control_set_bounds, 4);
  rb_define_method(cControl, 'begin_drag', @Control_begin_drag, -1);
{$IFDEF VCL}
  rb_define_method(cControl, 'perform', @Control_perform, 3);
{$ENDIF}

  { properties }
  DefineAttrSet(cControl, 'rect', Control_set_rect);
  DefineAttrGet(cControl, 'rect', Control_get_rect);
  DefineAttrSet(cControl, 'align', Control_set_align);
  DefineAttrGet(cControl, 'align', Control_get_align);
  DefineAttrSet(cControl, 'parent', Control_set_parent);
  DefineAttrGet(cControl, 'handle', Control_get_handle);
  DefineAttrSet(cControl, 'control_state', Control_set_control_state);
  DefineAttrGet(cControl, 'control_state', Control_get_control_state);
  DefineAttrSet(cControl, 'control_style', Control_set_control_style);
  DefineAttrGet(cControl, 'control_style', Control_get_control_style);
  { attributes }
  rb_define_attr(cControl, 'parent', 1, 0);
  OutputAttrMethod_retval(cControl, 'on_context_popup');

  cWinControl := OutputPersistentClass(mPhi, TWinControl, cControl, nil);
  rb_define_method(cWinControl, 'focused?', @Control_focused_p, 0);
  rb_define_method(cWinControl, 'set_focus', @Control_set_focus, 0);
  rb_define_method(cWinControl, 'scale_by', @Control_scale_by, 2);
  rb_define_method(cControl, 'invalidate', @Control_invalidate, 0);
  rb_define_method(cControl, 'update', @Control_update, 0);
  rb_define_method(cControl, 'repaint', @Control_repaint, 0);
  rb_define_method(cControl, 'refresh', @Control_refresh, 0);
  DefineMethod(cWinControl, 'controls', Control_get_controls);
  DefineAttrGet(cWinControl, 'control_count', Control_get_control_count);

  rb_define_method(cWinControl, 'stop_align', @Control_stop_align, 0);
  rb_define_method(cWinControl, 'handle_needed', @Control_handle_needed, 0);
  //[ap-dev:0826] rename
  rb_define_method(cWinControl, 'control_at_pos', @Control_control_at_pos, 1);
  rb_define_alias(cWinControl, 'control_at', 'control_at_pos');
  rb_define_method(cWinControl, 'select_first', @Control_select_first, 0);
  rb_define_method(cWinControl, 'select_next', @Control_select_next, 3);
  rb_define_method(cWinControl, 'showing?', @Control_showing_p, 0);
{$IFDEF VCL}
  DefineAttrSet(cWinControl, 'double_buffered', Control_set_double_buffered);
  DefineAttrGet(cWinControl, 'double_buffered', Control_get_double_buffered);
{$ENDIF}
  rb_define_method(cWinControl, 'client_rect', @Control_client_rect, 0);
  rb_define_method(cWinControl, 'adjusted_client_rect', @Control_adjusted_client_rect, 0);

  DefineAttrSet(cControl, 'action', Control_set_action);
  DefineAttrGet(cControl, 'action', Control_get_action);
(**** str3 made by ap_src_maker ****)
  // remove do_xx, get_xx => xx
  rb_define_method(cWinControl, 'can_focus', @WinControl_can_focus, 0);
  rb_define_method(cWinControl, 'contains_control', @WinControl_contains_control, 1);
  rb_define_method(cWinControl, 'disable_align', @WinControl_disable_align, 0);
{$IFDEF VCL}
  DefineAttrGet(cWinControl, 'dock_client_count', WinControl_get_dock_client_count);
  rb_define_method(cWinControl, 'dock_drop', @WinControl_dock_drop, 3);
{$ENDIF}
  rb_define_method(cWinControl, 'enable_align', @WinControl_enable_align, 0);
  rb_define_method(cWinControl, 'find_child_control', @WinControl_find_child_control, 1);
  rb_define_method(cWinControl, 'flip_children', @WinControl_flip_children, 1);
  rb_define_method(cWinControl, 'focused', @WinControl_focused, 0);
  rb_define_method(cWinControl, 'tab_order_list', @WinControl_get_tab_order_list, 1);
  rb_define_method(cWinControl, 'handle_allocated', @WinControl_handle_allocated, 0);
  rb_define_method(cWinControl, 'insert_control', @WinControl_insert_control, 1);
  rb_define_method(cWinControl, 'remove_control', @WinControl_remove_control, 1);
  rb_define_method(cWinControl, 'realign', @WinControl_realign, 0);
  rb_define_method(cWinControl, 'scroll_by', @WinControl_scroll_by, 2);
  rb_define_method(cWinControl, 'update_control_state', @WinControl_update_control_state, 0);
{$IFDEF VCL}
  DefineAttrGet(cWinControl, 'align_disabled', WinControl_get_align_disabled);
  DefineAttrGet(cWinControl, 'align_disabled?', WinControl_get_align_disabled);
  DefineAttrGet(cWinControl, 'visible_dock_client_count', WinControl_get_visible_dock_client_count);
  DefineAttrGet(cWinControl, 'parent_window', WinControl_get_parent_window);
  DefineAttrSet(cWinControl, 'parent_window', WinControl_set_parent_window);
{$ENDIF}
  DefineAttrGet(cWinControl, 'showing', WinControl_get_showing);
  DefineAttrGet(cWinControl, 'showing?', WinControl_get_showing);
  DefineAttrGet(cWinControl, 'tab_stop', WinControl_get_tab_stop);
  DefineAttrGet(cWinControl, 'tab_stop?', WinControl_get_tab_stop);
  DefineAttrSet(cWinControl, 'tab_stop', WinControl_set_tab_stop);
  rb_define_method(cWinControl, 'action_change', @WinControl_action_change, 2);
  rb_define_method(cWinControl, 'assign_to', @WinControl_assign_to, 1);
  rb_define_method(cWinControl, 'adjust_client_rect', @WinControl_adjust_client_rect, 1);
  rb_define_method(cWinControl, 'adjust_size', @WinControl_adjust_size, 0);
  rb_define_method(cWinControl, 'align_controls', @WinControl_align_controls, 2);
{$IFDEF VCL}
  rb_define_method(cWinControl, 'can_auto_size', @WinControl_can_auto_size, 2);
  rb_define_method(cWinControl, 'can_resize', @WinControl_can_resize, 2);
{$ENDIF}
  rb_define_method(cWinControl, 'change_scale', @WinControl_change_scale, 2);
  rb_define_method(cWinControl, 'constrained_resize', @WinControl_constrained_resize, 4);
  rb_define_method(cWinControl, 'controls_aligned', @WinControl_controls_aligned, 0);
  rb_define_method(cWinControl, 'create_handle', @WinControl_create_handle, 0);
{$IFDEF VCL}
  rb_define_method(cWinControl, 'create_wnd', @WinControl_create_wnd, 0);
{$ENDIF}
  rb_define_method(cWinControl, 'custom_align_insert_before', @WinControl_custom_align_insert_before, 2);
  rb_define_method(cWinControl, 'define_properties', @WinControl_define_properties, 1);
  rb_define_method(cWinControl, 'destroy_handle', @WinControl_destroy_handle, 0);
{$IFDEF VCL}
  rb_define_method(cWinControl, 'destroy_window_handle', @WinControl_destroy_window_handle, 0);
  rb_define_method(cWinControl, 'destroy_wnd', @WinControl_destroy_wnd, 0);
{$ENDIF}
  rb_define_method(cWinControl, 'find_next_control', @WinControl_find_next_control, 4);
  rb_define_method(cWinControl, 'fixup_tab_list', @WinControl_fixup_tab_list, 0);
  rb_define_method(cWinControl, 'client_origin', @WinControl_get_client_origin, 0);
{$IFDEF VCL}
  rb_define_method(cWinControl, 'control_extents', @WinControl_get_control_extents, 0);
  rb_define_method(cWinControl, 'device_context', @WinControl_get_device_context, 1);
  rb_define_method(cWinControl, 'parent_handle', @WinControl_get_parent_handle, 0);
  rb_define_method(cWinControl, 'site_info', @WinControl_get_site_info, 4);
  rb_define_method(cWinControl, 'top_parent_handle', @WinControl_get_top_parent_handle, 0);
{$ENDIF}
  rb_define_method(cWinControl, 'key_press', @WinControl_key_press, 1);
{$IFDEF VCL}
  rb_define_method(cWinControl, 'paint_controls', @WinControl_paint_controls, 2);
  rb_define_method(cWinControl, 'paint_window', @WinControl_paint_window, 1);
  rb_define_method(cWinControl, 'palette_changed', @WinControl_palette_changed, 1);
  rb_define_method(cWinControl, 'read_state', @WinControl_read_state, 1);
  rb_define_method(cWinControl, 'recreate_wnd', @WinControl_recreate_wnd, 0);
  rb_define_method(cWinControl, 'reload_docked_control', @WinControl_reload_docked_control, 2);
  rb_define_method(cWinControl, 'reset_ime', @WinControl_reset_ime, 0);
{$ENDIF}
  rb_define_method(cWinControl, 'scale_controls', @WinControl_scale_controls, 2);
  rb_define_method(cWinControl, 'set_child_order', @WinControl_set_child_order, 2);
{$IFDEF VCL}
  rb_define_method(cWinControl, 'set_ime', @WinControl_set_ime, 0);
{$ENDIF}
  rb_define_method(cWinControl, 'set_z_order', @WinControl_set_z_order, 1);
  rb_define_method(cWinControl, 'show_control', @WinControl_show_control, 1);
{$IFDEF VCL}
  DefineAttrGet(cWinControl, 'ctl3d', WinControl_get_ctl3d);
  DefineAttrGet(cWinControl, 'ctl3d?', WinControl_get_ctl3d);
  DefineAttrSet(cWinControl, 'ctl3d', WinControl_set_ctl3d);
  DefineAttrSet(cWinControl, 'def_wnd_proc', WinControl_set_def_wnd_proc);
  DefineAttrGet(cWinControl, 'dock_site', WinControl_get_dock_site);
  DefineAttrGet(cWinControl, 'dock_site?', WinControl_get_dock_site);
  DefineAttrSet(cWinControl, 'dock_site', WinControl_set_dock_site);
  DefineAttrGet(cWinControl, 'parent_ctl3d', WinControl_get_parent_ctl3d);
  DefineAttrGet(cWinControl, 'parent_ctl3d?', WinControl_get_parent_ctl3d);
  DefineAttrSet(cWinControl, 'parent_ctl3d', WinControl_set_parent_ctl3d);
  DefineAttrGet(cWinControl, 'use_dock_manager', WinControl_get_use_dock_manager);
  DefineAttrGet(cWinControl, 'use_dock_manager?', WinControl_get_use_dock_manager);
  DefineAttrSet(cWinControl, 'use_dock_manager', WinControl_set_use_dock_manager);
  DefineAttrGet(cWinControl, 'window_handle', WinControl_get_window_handle);
  DefineAttrSet(cWinControl, 'window_handle', WinControl_set_window_handle);

  DefineAttrGet(cWinControl, 'bevel_width', WinControl_get_bevel_width);
  DefineAttrSet(cWinControl, 'bevel_width', WinControl_set_bevel_width);
  DefineAttrGet(cWinControl, 'border_width', WinControl_get_border_width);
  DefineAttrSet(cWinControl, 'border_width', WinControl_set_border_width);
  DefineAttrGet(cWinControl, 'ime_mode', WinControl_get_ime_mode);
  DefineAttrSet(cWinControl, 'ime_mode', WinControl_set_ime_mode);
  DefineAttrGet(cWinControl, 'ime_name', WinControl_get_ime_name);
  DefineAttrSet(cWinControl, 'ime_name', WinControl_set_ime_name);
{$ENDIF}
(**** made by ap_src_maker ****)
end;

end.
