unit uDdeServerItem;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  DdeMan,
  DDEml,
  Rubies;

var
  cDdeServerItem: Tvalue;

function ap_cDdeServerItem: Tvalue;
function ap_iDdeServerItem(real: TDdeServerItem; owner: Tvalue): Tvalue;
procedure Init_DdeServerItem;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv,
  uIndexer,
  Graphics,
  uPersistent, uComponent, uControl;

function ap_cDdeServerItem: Tvalue;
begin
  result := cDdeServerItem;
end;

procedure DdeServerItem_setup(obj: Tvalue; real: TDdeServerItem);
begin
//    AssignPropMethod(real, [Handle]);
end;

function DdeServerItem_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function DdeServerItem_alloc(This: Tvalue; real: TDdeServerItem): Tvalue;
begin
  result := ChildAlloc(This, real);
  DdeServerItem_setup(result, real);
end;

function ap_iDdeServerItem(real: TDdeServerItem; owner: Tvalue): Tvalue;
begin
  result := DdeServerItem_alloc(cDdeServerItem, real);
  ap_owner(result, owner);
end;

function ap_iDdeServerItem_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDdeServerItem(TDdeServerItem(AControl), owner);
end;

function DdeServerItem_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDdeServerItem;
begin
  real := TDdeServerItem.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  DdeServerItem_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_DdeServerItem = class(TDdeServerItem)
  protected
    procedure Change;override;
  public
    procedure inherited_Change;
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function DdeServerItem_poke_data(This, Data : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeServerItem;
  dlv_Data : HDdeData;
begin
  real := ap_data_get_struct(This);
  dlv_Data := HDdeData(dl_Handle(Data));
  result := ap_Integer(real.PokeData( dlv_Data ));
end;

function DdeServerItem_copy_to_clipboard(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeServerItem;
begin
  real := ap_data_get_struct(This);
  real.CopyToClipboard;
  result := This;
end;

var
  id_change: Tid;
procedure TPhi_DdeServerItem.Change;
begin
  rb_funcall2(Self.tag, id_change, 0, nil);
end;
procedure TPhi_DdeServerItem.inherited_Change;
begin
  inherited Change;
end;
function DdeServerItem_change(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeServerItem;
begin
  real := ap_data_get_struct(This);
  real.inherited_Change;
  result := This;
end;

function DdeServerItem_get_fmt(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DdeServerItem;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.Fmt);  
end;
(**** made by ap_src_maker ****)

procedure Init_DdeServerItem;
begin
  cDdeServerItem := OutputPersistentClass(mPhi, TDdeServerItem, cWinControl, ap_iDdeServerItem_v);
  rb_define_method(cDdeServerItem, 'event_handle', @DdeServerItem_event_handle, 1);
  DefineSingletonMethod(cDdeServerItem, 'new', DdeServerItem_new);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cDdeServerItem, 'poke_data', @DdeServerItem_poke_data, 1);
  rb_define_method(cDdeServerItem, 'copy_to_clipboard', @DdeServerItem_copy_to_clipboard, 0);
  id_change := rb_intern('change');
  rb_define_method(cDdeServerItem, 'change', @DdeServerItem_change, 0);
  DefineAttrGet(cDdeServerItem, 'fmt', DdeServerItem_get_fmt);
(**** made by ap_src_maker ****)

end;

end.
