unit uFrame;

interface

uses
{$IFDEF VCL}
  Forms,
{$ELSE}
  QForms,
{$ENDIF}
  Rubies;

var
  cFrame: Tvalue;

procedure Frame_setup(obj: Tvalue; real: TFrame);
function Frame_alloc(This: Tvalue; real: TFrame): Tvalue;
procedure Init_Frame;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

procedure Frame_setup(obj: Tvalue; real: TFrame);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  ap_set_child_attr_module(obj);
//    AssignPropMethod(real, [Handle]);
end;

function Frame_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Frame_alloc(This: Tvalue; real: TFrame): Tvalue;
begin
  result := ChildAlloc(This, real);
  Frame_setup(result, real);
end;

function ap_iFrame(real: TFrame; owner: Tvalue): Tvalue;
begin
  result := Frame_alloc(cFrame, real);
  ap_owner(result, owner);
end;

function ap_iFrame_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iFrame(TFrame(AControl), owner);
end;

function Frame_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TFrame;
begin
  real := TFrame.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Frame_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_Frame;
begin
  cFrame := OutputPersistentClass(mPhi, TFrame, cWinControl, ap_iFrame_v);
  rb_define_method(cFrame, 'event_handle', @Frame_event_handle, 1);
  DefineSingletonMethod(cFrame, 'new', Frame_new);
end;


end.
