unit uRadioGroup;

interface

uses
{$IFDEF VCL}
  ExtCtrls,
{$ELSE}
  QExtCtrls,
{$ENDIF}
  Rubies;

var
  cradioGroup: Tvalue;

function ap_cRadioGroup: Tvalue;
function ap_iRadioGroup(real: TRadioGroup; owner: Tvalue): Tvalue;
procedure Init_RadioGroup;

implementation

uses
  Classes,
  uDefUtils, uIntern, uAlloc, uProp, uPhi,
  uSizeConstraints, uStrings,
  uPersistent, uComponent, uControl, uGroupBox;

function ap_cRadioGroup: Tvalue;
begin
  result := cRadioGroup;
end;

procedure RadioGroup_setup(obj: Tvalue; real: TRadioGroup);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
  rb_iv_set(obj, '@items', ap_iStrings(real.Items, obj));
  ap_set_child_attr_module(obj);
end;

function RadioGroup_alloc(This: Tvalue; real: TRadioGroup): Tvalue;
begin
  result := ChildAlloc(This, real);
  RadioGroup_setup(result, real);
end;

function ap_iRadioGroup(real: TRadioGroup; owner: Tvalue): Tvalue;
begin
  result := RadioGroup_alloc(cRadioGroup, real);
  ap_owner(result, owner);
end;

function ap_iRadioGroup_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iRadioGroup(TRadioGroup(AControl), owner);
end;

function RadioGroup_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TRadioGroup;
begin
  real := TRadioGroup.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  RadioGroup_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

procedure Init_RadioGroup;
begin
  cRadioGroup := OutputPersistentClass(mPhi, TRadioGroup, cGroupBox, ap_iRadioGroup_v);
  DefineSingletonMethod(cRadioGroup, 'new', RadioGroup_new);
end;

end.
