unit uStaticText;

interface

uses Rubies, StdCtrls;

var
  cStaticText: Tvalue;

function ap_cStaticText: Tvalue;
function ap_iStaticText(real: TStaticText; owner: Tvalue): Tvalue;
procedure Init_StaticText;

implementation

uses
  Classes,
  uConv, uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uBrush, uFont,
  uPersistent, uComponent, uControl;

function ap_cStaticText: Tvalue;
begin
  result := cStaticText;
end;

procedure StaticText_setup(obj: Tvalue; real: TStaticText);
begin
  rb_iv_set(obj, '@brush', ap_iBrush(real.Brush, obj));
  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function StaticText_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function StaticText_alloc(This: Tvalue; real: TStaticText): Tvalue;
begin
  result := ChildAlloc(This, real);
  StaticText_setup(result, real);
end;

function ap_iStaticText(real: TStaticText; owner: Tvalue): Tvalue;
begin
  result := StaticText_alloc(cStaticText, real);
  ap_owner(result, owner);
end;

function ap_iStaticText_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iStaticText(TStaticText(AControl), owner);
end;

function StaticText_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStaticText;
begin
  real := TStaticText.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  StaticText_setup(result, real);
  ap_obj_call_init(result, argc, argv);
end;

function StaticText_set_caption(This, v: Tvalue): Tvalue; cdecl;
var
  real: TStaticText;
begin
  real := ap_data_get_struct(This);
  real.caption := dl_String(v);
  result := v;
end;

procedure Init_StaticText;
begin
  cStaticText := OutputPersistentClass(mPhi, TStaticText, cWinControl, ap_iStaticText_v);
  rb_define_method(cStaticText, 'event_handle', @StaticText_event_handle, 1);
  DefineSingletonMethod(cStaticText, 'new', StaticText_new);
  DefineAttrSet(cStaticText, 'caption', StaticText_set_caption);
  rb_define_attr(cStaticText, 'brush', 1, 0);
  rb_define_attr(cStaticText, 'font', 1, 0);
end;

end.
