using System;
using System.Drawing;
using System.Windows.Forms;

namespace AppliStation.Util
{
	/// <summary>
	/// Description of ExceptionDialogForm.
	/// </summary>
	public partial class ExceptionDialogForm : Form
	{
		public ExceptionDialogForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
		}
		
		private static void Application_ThrowException(Exception e)
		{
			try {
				ExceptionDialogForm form = new ExceptionDialogForm();
				if (e != null) {
					form.detailTextBox.Text = e.ToString() + System.Environment.NewLine + e.StackTrace;
				} else {
					form.viewDetailButton.Visible = false;
				}
				
				switch (form.ShowDialog()) {
					case DialogResult.Cancel:
						return;
					default:
						Application.Exit();
						break;
				}
			} catch {
				MessageBox.Show("dȃG[̂ŏI܂B\n" + e.ToString(), "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
				Application.Exit();
			}
		}
		
		public static void Application_ThrowException(object sender, System.Threading.ThreadExceptionEventArgs e)
		{
			Application_ThrowException(e.Exception);
		}
		
		public static void Application_ThrowException(object sender, UnhandledExceptionEventArgs e)
		{
			Application_ThrowException((Exception) e.ExceptionObject);
		}
		
		void ViewDetailLabelLinkClicked(object sender, EventArgs e)
		{
			this.detailTextBox.Visible = true;
			this.viewDetailButton.Enabled = false;
			this.Size = new Size(this.Size.Width, this.Size.Height + 250);
		}
		
		void Form_Shown(object sender, EventArgs e)
		{
			this.quitButton.Focus();
		}
	}
}
