using System;
using System.IO;
using System.Collections.Generic;

namespace NaGet.Packages
{
	/// <summary>
	/// パッケージリストを提供するプロバイダのリストを示すクラス
	/// </summary>
	public class ProviderList
	{
		/// <summary>
		/// パッケージリストのリソースURLの配列
		/// </summary>
		public string[] Urls;
		
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public ProviderList()
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="path">プロバイダリストのファイルのパス</param>
		public ProviderList(string path)
		{
			List<string> providerList = new List<string>();
			using(StreamReader reader = new StreamReader(path)) {
				string line;
				while ((line = reader.ReadLine()) != null) {
					providerList.Add(line);
				}
			}
			
			Urls = providerList.ToArray();
		}
	}
}
