using System;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace NaGet
{
	/// <summary>
	/// @\Ȉ͂B
	/// </summary>
	public class ArgParser
	{
		/// <summary>
		/// ͌
		/// </summary>
		private Dictionary<string,object> opts;
		
		/// <summary>
		/// ͌ʂnbVƂĎ擾
		/// </summary>
		public Dictionary<string, object> Opts {
			get {
				lock (opts) {
					return opts;
				}
			}
		}
		
		public ArgParser()
			: this(new Dictionary<string,object>())
		{
		}
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="hashDefault">̎</param>
		public ArgParser(Dictionary<string,object> hashDefault)
		{
			opts = hashDefault;
		}
		
		/// <summary>
		/// nbV̒gݒ肠邢͎擾B
		/// </summary>
		public object this[string key] {
			set {
				lock(opts) {
					opts[key] = value;
				}
			}
			get {
				lock(opts) {
					return opts[key];
				}
			}
		}
		
		/// <summary>
		/// ͂
		/// </summary>
		/// <param name="args">Ώۈ</param>
		/// <returns>c(IvVł͂Ȃ)</returns>
		/// <exception cref="ApplicationException">sȂƂ܂́A݂ȂIvV݂Ƃ</exception>
		public string[] Parse(string[] args)
		{
			List<string> rest = new List<string>();
			lock (opts) {
				bool disableOptionParse = false;
				for (int i = 0; i < args.Length; i++) {
					if (disableOptionParse || !args[i].StartsWith("-")) {
						rest.Add(args[i]);
					} else {
						if (args[i].StartsWith("-")) {
							if (args[i] == "--") {
								// IvV͒f
								disableOptionParse = true;
							} else {
								parseOption(args[i]);
							}
						}
					}
				}
			}
			
			return rest.ToArray();
		}
		
		/// <summary>
		/// IvVg[ŃAǂݍ݂Ȃ
		/// </summary>
		/// <param name="option">IvVg[N</param>
		/// <exception cref="ApplicationException">sȂƂ܂́A݂ȂIvV̏ꍇ</exception>
		private void parseOption(string option)
		{
			Match match = Regex.Match(option, "^--?([^=]+)(=\"?(.+)\"?)?$");
			if (match.Success) {
				string key = match.Groups[1].Value;
				string val = match.Groups[3].Value;
				
				if (opts.ContainsKey(key)) { // o^ʂɓĂ邱
					object origVal = opts[key];
					
					try {
						if (origVal is bool) {
							opts[key] = val.ToLower() != "no";
						} else if (origVal is int) {
							opts[key] = int.Parse(val);
						} else /* if (origVal is string) */ {
							opts[key] = val;
						}
					} catch (FormatException) {
						throw new ApplicationException(string.Format("Illegal Format For {0}", key));
					}
				} else {
					throw new ApplicationException(string.Format("Undefined option: {0}", key));
				}
			}
		}
	}
}
