﻿using System;
using System.Collections.Generic;
using Microsoft.Win32;

namespace NaGet.Net
{
	/// <summary>
	/// ICatManagerの暫定的かつピュアC#実装。レジストリを舐めてICatManagerと同等の機能を実現する。
	/// </summary>
	class GuidEnumeratorForCategories : IEnumerable<Guid>, IDisposable
	{
		private RegistryKey key;
		
		private string[] subkeys;
		
		private Guid catGuid;
		
		public GuidEnumeratorForCategories(Guid category)
		{
			key = Registry.ClassesRoot.OpenSubKey(@"CLSID", false);
			subkeys = key.GetSubKeyNames();
			catGuid = category;
		}
		
		public void Dispose()
		{
			if (key != null) {
				key.Close();
			}
		}
		
		
		public IEnumerator<Guid> GetEnumerator()
		{
			return _getEnumerator();
		}
		
		System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
		{
			return _getEnumerator();
		}
		
		private IEnumerator<Guid> _getEnumerator()
		{
			// レジストリ内のImplemented Category内の値と比較する値
			string strCategory = catGuid.ToString("B").ToUpper();
			
			foreach (string subkey in subkeys) {
				// "CLSID"、基本タイプ（"...046}"）は無視する
				if ((subkey == "CLSID") ||
				     subkey.EndsWith("-0000-0000-C000-000000000046}", StringComparison.OrdinalIgnoreCase)) {
					continue;
				}

				// Implemented Categoryにあれば、subkeyをGUIDに変換して返す
				RegistryKey guidKey = key.OpenSubKey(string.Format(@"{0}\Implemented Categories\{1}", subkey, strCategory), false);
				if (guidKey != null) {
					guidKey.Close();
					yield return new Guid(subkey);
				}
			}
		}
	}
}
