using System;
using System.Xml.Serialization;
using System.Collections.Generic;
using System.IO;
using NaGet.Packages;

namespace ArchiveInstall
{
	public class InstalledFileList
	{
		[XmlElement("Entry")]
		public List<InstalledFile> Entries;
		
		public InstalledFileList()
		{
			Entries = new List<InstalledFile>();
		}
		
		/// <summary>
		/// nbV؂sAύXꂽƊmF(ÓłȂ)t@CԂ
		/// </summary>
		/// <param name="rootDirectory">t@C̃[gfBNg</param>
		/// <returns>ύXꂽƌot@C()</returns>
		public IEnumerable<InstalledFile> Verify(string rootDirectory)
		{
			foreach (InstalledFile file in Entries) {
				string filepath = Path.Combine(rootDirectory, file.Path);
				
				if (File.Exists(filepath) && (! file.Hash.Validate(filepath))) {
					yield return file;
				}
			}
		}
		
		public static InstalledFileList CreateFromFiles(string rootDirectory)
		{
			InstalledFileList list = new InstalledFileList();
			foreach (string filepath in Directory.GetFiles(rootDirectory, "*", SearchOption.AllDirectories)) {
				string relativePath = NaGet.Utils.GetRelativePath(rootDirectory, filepath);
				if (relativePath.StartsWith(".applistation.")) {
					continue;
				}
				
				InstalledFile file = new InstalledFile();
				file.Path = relativePath;
				file.Hash = new HashValue();
				file.Hash.Type = HashValueType.SHA1SUM;
				file.Hash.Value = HashValue.HashValueFor(filepath, file.Hash.Type);
				
				list.Entries.Add(file);
			}
			return list;
		}
	}
	
	public class InstalledFile
	{
		/// <summary>
		/// t@C̃pX
		/// </summary>
		public string Path;
		
		/// <summary>
		/// nbVl
		/// </summary>
		public HashValue Hash;
		
		public InstalledFile()
		{
		}
	}
}
