/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.action;

import java.util.List;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;

import applicationpattern.entity.User;
import applicationpattern.query.ApplicationQuery;
import applicationpattern.query.UserListQuery;
import applicationpattern.searchcondition.UserListSearchCondition;
import applicationpattern.util.UrlUtil;

@Scope(ScopeType.PAGE)
@Name("userListAction")
public class UserListAction extends ApplicationListAction {	
	private UserListSearchCondition userListSearchCondition = new UserListSearchCondition();
	
	@DataModelSelection
	private User selectedUser;
	
	@DataModel
	private List<User> userListSearchResult;
	
	@In(create=true)
	private UserListQuery userListQuery;
	
	@Override
	public ApplicationQuery getQuery() {
		return userListQuery;
	}
	
	@Create
	public void init()
	{
		userListSearchResult = null;
		userListSearchCondition = new UserListSearchCondition();
	}
	
	@Override
	public void search()
	{		
		userListSearchResult = userListQuery.getResultList();
		setSearchResultTotalCount(userListQuery.getResultCount().intValue());
	}
	
	public String showDetail()
	{
		return UrlUtil.getUserMasterUrl(selectedUser);
	}
	
	/////////////////////////////////
	// getter/setter
	/////////////////////////////////

	public UserListSearchCondition getUserListSearchCondition() {
		return userListSearchCondition;
	}

	public void setUserListSearchCondition(
			UserListSearchCondition userListSearchCondition) {
		this.userListSearchCondition = userListSearchCondition;
	}

	public List<User> getUserListSearchResult() {
		return userListSearchResult;
	}

	public void setUserListSearchResult(List<User> searchResult) {
		this.userListSearchResult = searchResult;
	}

	public UserListQuery getUserListQuery() {
		return userListQuery;
	}

	public void setUserListQuery(UserListQuery userListQuery) {
		this.userListQuery = userListQuery;
	}

	public User getSelectedUser() {
		return selectedUser;
	}

	public void setSelectedUser(User selectedUser) {
		this.selectedUser = selectedUser;
	}

}
