/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.converter;

import java.math.BigDecimal;
import java.text.DecimalFormat;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

import org.apache.commons.lang.StringUtils;
import org.jboss.el.util.MessageFactory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.faces.FacesMessages;

@Name("priceConverter")
@org.jboss.seam.annotations.faces.Converter
@BypassInterceptors
public class PriceConverter implements Converter {

	public Object getAsObject(FacesContext arg0, UIComponent arg1, String arg2) {
		try
		{
			if (StringUtils.isEmpty(arg2))
			{
				return arg2;
			}
			return new BigDecimal(arg2.toString().replace(",", ""));
		}
		catch(NumberFormatException e)
		{
			throw new ConverterException(
					FacesMessages.createFacesMessage(FacesMessage.SEVERITY_ERROR,
							"applicationpattern.converter.Price.format", ""));			
		}
	}

	public String getAsString(FacesContext arg0, UIComponent arg1, Object arg2) {
		DecimalFormat formatter = new DecimalFormat("#,###");
		try
		{
			return formatter.format(arg2);
		}
		catch(IllegalArgumentException e)
		{
			throw new ConverterException(
					FacesMessages.createFacesMessage(FacesMessage.SEVERITY_ERROR,
							"applicationpattern.converter.Price.format", ""));
		}
	}

}
