/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.interceptor;

import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.log.Logging;

public class TraceCallInterceptor {
	
	@AroundInvoke
	public Object traceMethod(InvocationContext invocation) throws Exception {
		Logging.getLogProvider(this.getClass()).info(
				String.format("call %s", getTargetClassAndMethodName(invocation)));
		
		Object result = invocation.proceed();
		
		Logging.getLogProvider(this.getClass()).info(
				String.format("called %s", getTargetClassAndMethodName(invocation)));
		
		return result;
	}

	private String getTargetClassAndMethodName(InvocationContext invocation) {
		return String.format("%s.%s()",
			invocation.getTarget().getClass().getName(),
			invocation.getMethod().getName());
	}
}
