/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.query;

import java.util.Arrays;

import org.jboss.seam.annotations.Name;

import applicationpattern.entity.Order;

@Name("orderListQuery")
public class OrderListQuery extends ApplicationQuery<Order> {
	private static final String EJBQL = "select o from Order o";
	private static final String[] RESTRICTIONS = { 		
		"o.id = #{orderListAction.orderListSearchCondition.id}",		
		"(SELECT SUM(item.price) FROM OrderItem item WHERE item.id.orderId = o.id ) >= #{orderListAction.orderListSearchCondition.minPrice}",
		"(SELECT SUM(item.price) FROM OrderItem item WHERE item.id.orderId = o.id ) <= #{orderListAction.orderListSearchCondition.maxPrice}",
	};
	
	public OrderListQuery() {
		setEjbql(EJBQL);		
		setRestrictionExpressionStrings(Arrays.asList(RESTRICTIONS));
		setMaxResults(5);
	}
}
