/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.action;

import org.jboss.seam.jsf.ListDataModel;
import org.testng.Assert;
import org.testng.annotations.Test;

import applicationpattern.ApplicationDBUnitTest;

public class UserListActionTest extends ApplicationDBUnitTest {
	
	@Test
	public void testSearch() throws Exception
	{
		new FacesRequest()
		{
			@Override
			protected void updateModelValues() throws Exception {
				setValue("#{userListAction.userListSearchCondition.id}", new Long(1));
			}

			@Override
			protected void invokeApplication() throws Exception {
				UserListAction userListAction = (UserListAction) getInstance(UserListAction.class);
				userListAction.search();
				assert userListAction.getSearchResultTotalCount() == 1;
			}

			@Override
			protected void renderResponse() throws Exception {
				ListDataModel userListSearchResult = (ListDataModel)getInstance("userListSearchResult");
				assert userListSearchResult.getRowCount() == 1;
				Assert.assertEquals(
						getValue("#{userListSearchResult.size}"), 1);
				
			}
			
		}.run();
	}

}
