/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2009 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef _D_HTTP_SERVER_H_
#define _D_HTTP_SERVER_H_

#include "common.h"

#include <string>
#include <sstream>

#include "SharedHandle.h"
#include "SocketBuffer.h"

namespace aria2 {

class SocketCore;
class HttpHeader;
class HttpHeaderProcessor;
class DownloadEngine;
class Logger;

class HttpServer {
private:
  SharedHandle<SocketCore> _socket;
  SocketBuffer _socketBuffer;
  DownloadEngine* _e;
  SharedHandle<HttpHeaderProcessor> _headerProcessor;
  Logger* _logger;
  SharedHandle<HttpHeader> _lastRequestHeader;
  uint64_t _lastContentLength;
  std::stringstream _lastBody;
  bool _keepAlive;
  std::string _username;
  std::string _password;
public:
  HttpServer(const SharedHandle<SocketCore>& socket, DownloadEngine* e);

  ~HttpServer();

  SharedHandle<HttpHeader> receiveRequest();

  bool receiveBody();

  std::string getBody() const;

  const std::string& getRequestPath() const;

  void feedResponse(const std::string& text, const std::string& contentType);

  void feedResponse(const std::string& status,
		    const std::string& headers,
		    const std::string& text,
		    const std::string& contentType);

  bool authenticate();

  void setUsernamePassword
  (const std::string& username, const std::string& password)
  {
    _username = username;
    _password = password;
  }

  ssize_t sendResponse();

  bool sendBufferIsEmpty() const;

  bool supportsPersistentConnection() const;

  void enableKeepAlive() { _keepAlive = true; }

  void disableKeepAlive() { _keepAlive = false; }

  uint64_t getContentLength() const { return _lastContentLength; }
};

} // namespace aria2

#endif // _D_HTTP_SERVER_H_
