/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Checksum;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.Utilities;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.io.SizeDetectionOutputStream;
import jp.sourceforge.armadillo.lzh.CRC16;
import jp.sourceforge.armadillo.lzh.LzhEntry;
import jp.sourceforge.armadillo.lzh.LzhHuffmanEncoder;
import jp.sourceforge.armadillo.lzh.LzhOutputStream;
import jp.sourceforge.armadillo.lzh.LzssOutputStream;

public final class LzhArchiver
implements Archiver {
    private static final byte HEADER_LEVEL = 1;
    private LzhOutputStream los;
    private boolean includesDirectory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LzhArchiver(OutputStream outputStream) {
        this.los = new LzhOutputStream(outputStream);
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (!$assertionsDisabled && inputStream == null != (l == 0L)) {
            throw new AssertionError();
        }
        if (archiveEntry.isDirectory()) {
            if (!this.includesDirectory) {
                return;
            }
            LzhEntry lzhEntry = new LzhEntry(archiveEntry.getName());
            lzhEntry.setMethod("-lhd-");
            lzhEntry.setLastModified(archiveEntry.getLastModified());
            this.los.putNextEntry(lzhEntry);
            this.los.closeEntry();
        } else {
            String string;
            Trial trial = new Trial();
            File file = Utilities.createTemporaryFile();
            if (inputStream != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    int n;
                    byte[] byArray = new byte[8192];
                    for (long i = l; i > 0L; i -= (long)n) {
                        n = inputStream.read(byArray);
                        if (n < 0) {
                            break;
                        }
                        trial.write(byArray, 0, n);
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                    trial.flush();
                }
            }
            long l2 = file.length();
            long l3 = trial.getCompressedSize();
            if (l3 >= l2) {
                string = "-lh0-";
                l3 = l2;
            } else {
                string = "-lh5-";
            }
            LzhEntry lzhEntry = new LzhEntry(archiveEntry.getName());
            lzhEntry.setHeaderLevel((byte)1);
            lzhEntry.setMethod(string);
            lzhEntry.setCompressedSize(l3);
            lzhEntry.setSize(l2);
            lzhEntry.setLastModified(archiveEntry.getLastModified());
            lzhEntry.setCrc(trial.getCRC());
            this.los.putNextEntry(lzhEntry);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                IOUtilities.transferAll(fileInputStream, this.los);
                this.los.closeEntry();
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
            file.delete();
        }
    }

    public void close() throws IOException {
        this.los.close();
    }

    static {
        $assertionsDisabled = !LzhArchiver.class.desiredAssertionStatus();
    }

    private static final class Trial {
        private LzssOutputStream los;
        private SizeDetectionOutputStream compressedSizeCounter = new SizeDetectionOutputStream();
        private Checksum crc;

        Trial() {
            LzhHuffmanEncoder lzhHuffmanEncoder = new LzhHuffmanEncoder(this.compressedSizeCounter, 3);
            this.los = new LzssOutputStream(lzhHuffmanEncoder, 8192, 256, 3);
            this.crc = CRC16.newInstanceForHeader();
        }

        void write(byte[] byArray, int n, int n2) throws IOException {
            this.los.write(byArray, n, n2);
            this.crc.update(byArray, n, n2);
        }

        void flush() throws IOException {
            this.los.flush();
        }

        long getCompressedSize() {
            return this.compressedSizeCounter.getSize();
        }

        short getCRC() {
            return (short)(this.crc.getValue() & 0xFFFFL);
        }
    }
}

