/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.tar.TarEntry;
import jp.sourceforge.armadillo.tar.TarOutputStream;

public final class TarArchiver
implements Archiver {
    private TarOutputStream tos;
    private boolean includesDirectory;

    public TarArchiver(OutputStream outputStream) {
        this.tos = new TarOutputStream(outputStream);
        this.includesDirectory = true;
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (archiveEntry.isDirectory()) {
            if (!this.includesDirectory) {
                return;
            }
            TarEntry tarEntry = new TarEntry(archiveEntry.getName());
            tarEntry.setMode(0);
            tarEntry.setLastModified(archiveEntry.getLastModified());
            this.tos.putNextEntry(tarEntry);
            this.tos.closeEntry();
        } else {
            TarEntry tarEntry = new TarEntry(archiveEntry.getName());
            tarEntry.setSize(l);
            tarEntry.setLastModified(archiveEntry.getLastModified());
            this.tos.putNextEntry(tarEntry);
            IOUtilities.transferAll(inputStream, this.tos);
            this.tos.closeEntry();
        }
    }

    public void close() throws IOException {
        this.tos.close();
    }
}

