/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import jp.sourceforge.armadillo.ArchiveEntry;
import jp.sourceforge.armadillo.Archiver;
import jp.sourceforge.armadillo.io.IOUtilities;
import jp.sourceforge.armadillo.io.SizeDetectionOutputStream;
import jp.sourceforge.armadillo.zip.ZipEntry;
import jp.sourceforge.armadillo.zip.ZipOutputStream;

public final class ZipArchiver
implements Archiver {
    private ZipOutputStream zos;
    private boolean includesDirectory;

    public ZipArchiver(OutputStream outputStream) {
        this.zos = new ZipOutputStream(outputStream);
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (archiveEntry.isDirectory()) {
            if (!this.includesDirectory) {
                return;
            }
            ZipEntry zipEntry = new ZipEntry(archiveEntry.getName());
            zipEntry.setMethod(0);
            zipEntry.setCrc(0L);
            zipEntry.setSize(0L);
            zipEntry.setCompressedSize(0L);
            zipEntry.setLastModified(archiveEntry.getLastModified());
            this.zos.putNextEntry(zipEntry);
            this.zos.closeEntry();
        } else {
            ZipEntry zipEntry = new ZipEntry(archiveEntry.getName());
            zipEntry.setMethod(8);
            zipEntry.setOption((short)8);
            zipEntry.setLastModified(archiveEntry.getLastModified());
            this.zos.putNextEntry(zipEntry);
            IOUtilities.transferAll(inputStream, this.zos);
            this.zos.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeflatedSize(InputStream inputStream) throws IOException {
        SizeDetectionOutputStream sizeDetectionOutputStream = new SizeDetectionOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(sizeDetectionOutputStream);
        try {
            IOUtilities.transferAll(inputStream, deflaterOutputStream);
            deflaterOutputStream.finish();
        }
        finally {
            deflaterOutputStream.close();
        }
        return sizeDetectionOutputStream.getSize();
    }

    public void close() throws IOException {
        this.zos.close();
    }
}

