/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.armadillo.tar;

import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.armadillo.io.ArchiveInputStream;
import jp.sourceforge.armadillo.tar.TarEntry;
import jp.sourceforge.armadillo.tar.TarHeader;

public final class TarInputStream
extends ArchiveInputStream {
    private TarHeader header;
    private long skipSize;

    public TarInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public TarInputStream(InputStream inputStream, String string) {
        super(inputStream);
        this.header = new TarHeader(string);
        this.skipSize = 0L;
    }

    public TarEntry getNextEntry() throws IOException {
        long l;
        this.ensureOpen();
        if (this.remaining + this.skipSize > 0L) {
            this.remaining += this.skipSize;
            while (this.remaining > 0L) {
                long l2 = this.in.skip(this.remaining);
                this.remaining -= l2;
            }
        }
        this.remaining = 0L;
        this.skipSize = 0L;
        TarEntry tarEntry = this.header.read(this.in);
        if (tarEntry == null) {
            return null;
        }
        this.remaining = l = tarEntry.getSize();
        this.skipSize = TarHeader.getSkipSize(l);
        return tarEntry;
    }

    public void close() throws IOException {
        this.header = null;
        super.close();
    }
}

