package jp.sourceforge.armadillo;

import java.io.*;

import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.tar.*;

/**
 * TarA[JCuWJB
 * AntAPIgpTAR`̃A[JCuWJB
 */
public final class TarExpander implements Expander {

    private TarInputStream tis;

    /**
     * TarExpander̐B
     * @param is InputStream
     */
    public TarExpander(InputStream is) {
        this.tis = new TarInputStream(is);
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#nextEntry()
     */
    public ArchiveEntry nextEntry() throws IOException {
        TarEntry entry = tis.getNextEntry();
        if (entry == null) {
            return ArchiveEntry.NULL;
        }
        ArchiveEntry ae = new ArchiveEntry(entry.getName());
        ae.setLastModified(entry.getLastModified());
        ae.setSize(entry.getSize());
        return ae;
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#expand(java.io.OutputStream)
     */
    public long expand(OutputStream os) throws IOException {
        return IOUtilities.transferAll(tis, os);
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Expander#close()
     */
    public void close() throws IOException {
        tis.close();
    }

}
