package jp.sourceforge.armadillo;

import java.io.*;
import java.util.*;

/**
 * [eBeB\bhNXB
 */
public final class Utilities {

    /**
     * Utilities̐B
     */
    private Utilities() {
        // empty
    }

    /**
     * e|t@C̐B
     * @return e|t@C
     * @throws IOException o̓G[ꍇ 
     */
    public static File createTemporaryFile() throws IOException {
        File tmp = File.createTempFile("armadillo", ".tmp");
        tmp.deleteOnExit();
        return tmp;
    }

    /**
     * ftHgPrintWriter̎擾B
     * @return PrintWriter
     */
    static PrintWriter getDefaultPrintWriter() {
        return new PrintWriter(System.out, true);
    }

    /**
     * DOS`̕ϊB
     */
    public static final class DosTime {

        /**
         * Utilities.DosTime̐B
         */
        private DosTime() {
            // empty
        }

        /**
         * DOS`̒l擾B
         * @param milliseconds ~b`
         * @return DOS`(32bitl)
         */
        public static int getValue(long milliseconds) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(milliseconds);
            return (c.get(Calendar.YEAR) - 1980) << 25
                   | (c.get(Calendar.MONTH) + 1) << 21
                   | c.get(Calendar.DATE) << 16
                   | c.get(Calendar.HOUR_OF_DAY) << 11
                   | c.get(Calendar.MINUTE) << 5
                   | (c.get(Calendar.SECOND) / 2);
        }

        /**
         * DOS`~b`ɕϊB
         * @param dostime DOS`
         * @return ~b`
         */
        public static long toMilliSeconds(int dostime) {
            int year = dostime >> 25 & 0x7F;
            int month = dostime >> 21 & 0x0F;
            int day = dostime >> 16 & 0x1F;
            int hours = dostime >> 11 & 0x1F;
            int minutes = dostime >> 5 & 0x3F;
            int seconds = dostime & 0x3F;
            Calendar c = Calendar.getInstance();
            c.set(year + 1980, month - 1, day, hours, minutes, seconds);
            return c.getTimeInMillis();
        }

    }

    /**
     * Windows`̕ϊB
     */
    public static final class WindowsTime {

        /**
         * Utilities.WindowsTime̐B
         */
        private WindowsTime() {
            // empty
        }

        /**
         * Windows`~b`ɕϊB
         * @param fileTime Windows`
         * @return ~b`
         */
        public static long toMilliSeconds(long fileTime) {
            // (FILETIME - 369years * 365days * 86400secs * 1000000) / 10000
            return ((fileTime >>> 1) - 58222368000000000L) / 5000;
        }

    }

}
