package jp.sourceforge.armadillo;

import java.io.*;
import java.util.zip.*;

import jp.sourceforge.armadillo.io.*;
import jp.sourceforge.armadillo.zip.ZipEntry;
import jp.sourceforge.armadillo.zip.ZipOutputStream;

/**
 * ZipA[JCoB
 * AntAPIgpZIP`̃A[JCu쐬B
 */
public final class ZipArchiver implements Archiver {

    private ZipOutputStream zos;
    private boolean includesDirectory;

    /**
     * ZipArchiver̐B
     * @param os OutputStream
     */
    public ZipArchiver(OutputStream os) {
        this.zos = new ZipOutputStream(os);
    }

    /**
     * includesDirectory̐ݒB
     * @param includesDirectory includesDirectory
     */
    public void setIncludesDirectory(boolean includesDirectory) {
        this.includesDirectory = includesDirectory;
    }

    /* (overridden)
     * @see jp.sourceforge.armadillo.Archiver#addEntry(jp.sourceforge.armadillo.ArchiveEntry, java.io.InputStream, long)
     */
    public void addEntry(ArchiveEntry ae, InputStream is, long length) throws IOException {
        if (ae.isDirectory()) {
            // fBNg
            if (!includesDirectory) {
                return;
            }
            ZipEntry entry = new ZipEntry(ae.getName());
            entry.setMethod(ZipEntry.STORED);
            entry.setCrc(0);
            entry.setSize(0);
            entry.setCompressedSize(0);
            entry.setLastModified(ae.getLastModified());
            zos.putNextEntry(entry);
            zos.closeEntry();
        } else {
            // t@C
            ZipEntry entry = new ZipEntry(ae.getName());
            entry.setMethod(ZipEntry.DEFLATED);
            entry.setOption((short)8);
            entry.setLastModified(ae.getLastModified());
            zos.putNextEntry(entry);
            IOUtilities.transferAll(is, zos);
            zos.closeEntry();
        }
    }

    /**
     * kTCY̎擾B
     * @param is InputStream
     * @return kTCY
     * @throws IOException o̓G[ꍇ 
     */
    public long getDeflatedSize(InputStream is) throws IOException {
        SizeDetectionOutputStream detector = new SizeDetectionOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(detector);
        try {
            IOUtilities.transferAll(is, dos);
            dos.finish();
        } finally {
            dos.close();
        }
        return detector.getSize();
    }

    /* (overridden)
     * @see java.io.Closeable#close()
     */
    public void close() throws IOException {
        zos.close();
    }

}
