package jp.sourceforge.armadillo.tar;

import java.io.*;
import java.nio.charset.*;
import java.util.*;

/**
 * TAR`A[JCũwb_B
 * 
 * <p>̃Cu̓dlƂāAŏIXV̓~b`Ƒ݂ɕϊB
 * GgIuWFNgɊi[ĂԂł́A~b`ƂB</p>
 * <p>GR[fBÓAftHgłJavãftHgGR[fBOKpB
 * Zbgw肳ꂽꍇ́A̕ZbgœǂݏB</p>
 * 
 * <h3>wb_̎dlɂ</h3>
 * <p>݂̃o[Wł́Austar`̂݃T|[gĂB</p>
 * <p>ɋLڂẮAȎdlł͂ȂƂɒӁB</p>
 * 
 * <h3>ustar`</h3>
 * <p>f[^܂߂āA1ubN(512oCg)Pʂŋ؂Bwb_͕KubN̐擪n܂B
 * TCY1ȏ̏ꍇ́Awb_̎̃ubNf[^ƂȂBfBNgȂǂ̏ꍇ͎̃wb_ƂȂB</p>
 * <p>l͐lƂċL^B̏I[Null(<code>0x00</code>)B
 * GR[fBÓAftHgł͕WITar̂悤ASCII`(͈͊OLN^'_'+8iŕ\)ƂĂB
 * Zbgw肳ꂽꍇ́A̕ZbgœǂݏB</p>
 * <p>100oCg𒴂GgipXjꍇ́AGgi[邽߂̃Ggݒ肳B
 * ̎dlɂẮAł͊B</p>
 */
public final class TarHeader {

    private static final int BLOCK_SIZE = 512;

    private byte[] bytes;
    private int position;
    private String charsetName;
    private boolean charsetEnables;

    /**
     * TarHeader̐B
     * ftHgZbggpB
     */
    public TarHeader() {
        this(null);
    }

    /**
     * TarHeader̐B
     * @param charsetName Zbg
     *                    ftHgZbggpꍇ <code>null</code> w肷
     */
    public TarHeader(String charsetName) {
        this.bytes = new byte[BLOCK_SIZE];
        this.position = 0;
        this.charsetName = charsetName;
        this.charsetEnables = charsetName != null && Charset.isSupported(charsetName);
    }

    /**
     * wb_ǂݎB
     * @param is ǂݎ茳
     * @return TarEntry
     * @throws IOException wb_ɓǂݎȂꍇ
     */
    public TarEntry read(InputStream is) throws IOException {
        reset();
        int readLength = is.read(bytes);
        if (readLength != BLOCK_SIZE) {
            throw new IOException("bad header: size=" + readLength);
        }
        if (bytes[0] == 0x00 && isEmptyBlock()) {
            if (is.read(bytes) == BLOCK_SIZE && isEmptyBlock()) {
                return null;
            }
            throw new IOException("bad end-of-archive");
        }
        String name = clip(100);
        TarEntry entry = new TarEntry(name);
        try {
            entry.setMode(clipAsInt(8));
            entry.setUid(clipAsInt(8));
            entry.setGid(clipAsInt(8));
            entry.setSize(clipAsLong(12));
            entry.setLastModified(clipAsLong(12) * 1000);
            entry.setChksum(clipAsInt(8));
            entry.setTypeFlag((char)bytes[position++]);
            entry.setLinkName(name);
            entry.setMagic(clip(6));
            entry.setVersion(clip(2));
            entry.setUname(clip(32));
            entry.setGname(clip(32));
            entry.setDevmajor(clip(8));
            entry.setDevminor(clip(8));
            entry.setPrefix(clip(155));
            if (entry.getTypeFlag() == 'L') {
                // LongLink support
                readLength = is.read(bytes);
                assert readLength == BLOCK_SIZE;
                position = 0;
                String longName = clip(BLOCK_SIZE);
                entry = read(is);
                entry.setName(longName);
            }
        } catch (RuntimeException ex) {
            IOException exception = new IOException("bad header at " + position);
            exception.initCause(ex);
            throw exception;
        }
        return entry;
    }

    /**
     * wb_ށB
     * @param os ݐ
     * @param entry TarEntry
     * @throws IOException wb_ɏ߂Ȃꍇ
     */
    public void write(OutputStream os, TarEntry entry) throws IOException {
        reset();
        try {
            patch(entry.getName(), 100);
            patch(entry.getMode(), 8);
            patch(entry.getUid(), 8);
            patch(entry.getGid(), 8);
            patch(entry.getSize(), 12);
            patch(entry.getLastModified() / 1000, 12);
            patch("        ", 8);
            patch(String.valueOf(entry.getTypeFlag()), 1);
            patch(entry.getLinkName(), 100);
            patch(entry.getMagic(), 6);
            patch(entry.getVersion(), 2);
            patch(entry.getUname(), 32);
            patch(entry.getGname(), 32);
            patch(entry.getDevmajor(), 8);
            patch(entry.getDevminor(), 8);
            patch(entry.getPrefix(), 155);
            int checksum = 0;
            for (int i = 0; i < bytes.length; i++) {
                checksum += (bytes[i] & 0xFF);
            }
            position = 148;
            patch(checksum, 6);
            entry.setChksum(checksum);
        } catch (RuntimeException ex) {
            IOException exception = new IOException("bad header at " + position);
            exception.initCause(ex);
            throw exception;
        }
        os.write(bytes);
    }

    /**
     * END-OF-ARCHIVEށB
     * @param os OutputStream
     * @throws IOException o̓G[ꍇ 
     */
    public void writeEndOfArchive(OutputStream os) throws IOException {
        reset();
        os.write(bytes);
        os.write(bytes);
        os.flush();
    }

    /**
     * ZbgB
     */
    public void reset() {
        position = 0;
        Arrays.fill(bytes, (byte)0);
    }

    /**
     * f[^؂oB
     * @param length 
     * @return ؂of[^
     */
    private String clip(int length) {
        assert length <= BLOCK_SIZE - position;
        int p = position;
        position += length;
        int availableLength = 0;
        for (int i = 0; i < length; i++) {
            if (bytes[p + i] == 0x00) {
                break;
            }
            ++availableLength;
        }
        if (charsetEnables) {
            try {
                return new String(bytes, p, availableLength, charsetName);
            } catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < availableLength; i++) {
            byte b = bytes[p + i];
            if ((b & 0x80) == 0x80) {
                buffer.append('\\');
                buffer.append(Integer.toOctalString(b & 0xFF));
            } else {
                buffer.append((char)b);
            }
        }
        return buffer.toString();
    }

    /**
     * f[^<code>int</code>lƂĐ؂oB
     * @param length 
     * @return ؂of[^
     */
    private int clipAsInt(int length) {
        return Integer.parseInt(clipAsNumberString(length), 8);
    }

    /**
     * f[^<code>long</code>lƂĐ؂oB
     * @param length 
     * @return ؂of[^
     */
    private long clipAsLong(int length) {
        return Long.parseLong(clipAsNumberString(length), 8);
    }

    /**
     * f[^𐔒lƂĐ؂oB
     * @param length 
     * @return ؂of[^
     */
    private String clipAsNumberString(int length) {
        assert length <= BLOCK_SIZE - position;
        int p = position;
        position += length;
        int i = 0;
        for (; i < length; i++) {
            byte b = bytes[p + i];
            if (b == 0x00) {
                break;
            }
            assert b >= 0x30 && b <= 0x39;
        }
        String s = new String(bytes, p, i);
        return s.trim();
    }

    /**
     * f[^pB
     * @param value l
     * @param length 
     * @return ۂɓ\t
     */
    private int patch(String value, int length) {
        int p = position;
        position += length;
        byte[] data;
        if (value == null) {
            data = new byte[0];
        } else if (charsetEnables) {
            try {
                data = value.getBytes(charsetName);
            } catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            data = value.getBytes();
        }
        System.arraycopy(data, 0, bytes, p, data.length);
        return data.length;
    }

    /**
     * f[^pB
     * @param value l
     * @param length 
     * @return ۂɓ\t
     */
    private int patch(int value, int length) {
        String s = padZero(Integer.toOctalString(value), length - 1);
        return patch(s + (char)0, length);
    }

    /**
     * f[^pB
     * @param value l
     * @param length 
     * @return ۂɓ\t
     */
    private int patch(long value, int length) {
        String s = padZero(Long.toOctalString(value), length - 1);
        return patch(s + (char)0, length);
    }

    /**
     * [()߂B
     * w肵̒ȏ̏ꍇ͕̂܂ܕԂB
     * @param value l
     * @param length 
     * @return [߂ꂽl
     */
    private String padZero(String value, int length) {
        int valueLength = value.length();
        if (valueLength >= length) {
            return value;
        }
        char[] buffer = new char[length];
        int p = length - valueLength;
        for (int i = 0; i < p; i++) {
            buffer[i] = '0';
        }
        for (int i = p; i < length; i++) {
            buffer[i] = value.charAt(i - p);
        }
        return String.valueOf(buffer);
    }

    /**
     * ubNǂׂB
     * @return ubN̏ꍇ <code>true</code>AłȂ <code>false</code> 
     */
    private boolean isEmptyBlock() {
        for (int i = 0; i < bytes.length; i++) {
            if (bytes[i] != 0x00) {
                return false;
            }
        }
        return true;
    }

    /**
     * XLbvTCY̎擾B
     * ubN̗]蕔̃XLbvɎgpB
     * @param size TCY
     * @return XLbvTCY
     */
    static long getSkipSize(long size) {
        if (size == 0 || size == BLOCK_SIZE || size % BLOCK_SIZE == 0) {
            return 0;
        } else {
            return BLOCK_SIZE - ((size > BLOCK_SIZE) ? size % BLOCK_SIZE : size);
        }
    }

}
