/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo;

public abstract class ProgressNotifier {
    public static final ProgressNotifier NullObject = new ProgressNotifier(1L){

        @Override
        public void progressNotified(long l, long l2) {
        }
    };
    private final long total;
    private long part;

    protected ProgressNotifier(long l) {
        assert (l > 0L);
        this.total = l;
    }

    protected final int getRateAsIntPercent() {
        if (this.part < 0L) {
            return 0;
        }
        if (this.part >= this.total) {
            return 100;
        }
        return (int)(100.0f / (float)this.total * (float)this.part);
    }

    protected final int getRateAsIntPermill() {
        if (this.part < 0L) {
            return 0;
        }
        if (this.part >= this.total) {
            return 1000;
        }
        return (int)(1000.0f / (float)this.total * (float)this.part);
    }

    protected final double getRate() {
        if (this.part < 0L) {
            return 0.0;
        }
        if (this.part >= this.total) {
            return 1.0;
        }
        long l = this.part / this.total;
        assert (l >= 0L && (double)l <= 1.0);
        return l;
    }

    public final void notifyFinished() {
        this.part = this.total;
        this.progressNotified(this.part, this.total);
    }

    public final void notifyProgress(long l) {
        this.part += l;
        this.progressNotified(this.part, this.total);
    }

    public abstract void progressNotified(long var1, long var3);
}

