/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive;

public enum ArchiveType {
    TAR,
    TARZ,
    TARGZ,
    TARBZ2,
    TARXZ,
    ZIP,
    LZH,
    CAB,
    Unknown;


    public static ArchiveType of(String string) {
        String string2 = ArchiveType.getExtension(string);
        if (string2.equalsIgnoreCase("tar")) {
            return TAR;
        }
        if (string2.equalsIgnoreCase("zip") || string2.equalsIgnoreCase("jar")) {
            return ZIP;
        }
        if (string2.equalsIgnoreCase("lzh")) {
            return LZH;
        }
        if (string2.equalsIgnoreCase("cab")) {
            return CAB;
        }
        if (ArchiveType.endsWithIgnoreCase(string, ".tar.z", ".tz", ".taz")) {
            return TARZ;
        }
        if (ArchiveType.endsWithIgnoreCase(string, ".tar.gz", ".tgz")) {
            return TARGZ;
        }
        if (ArchiveType.endsWithIgnoreCase(string, ".tar.bz2", ".tbz")) {
            return TARBZ2;
        }
        if (ArchiveType.endsWithIgnoreCase(string, ".tar.xz", ".txz")) {
            return TARXZ;
        }
        return Unknown;
    }

    static boolean endsWithIgnoreCase(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            int n;
            int n2 = string.length();
            if (n2 < (n = string2.length()) || !string.substring(n2 - n).equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1).toLowerCase();
    }
}

